/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.spring;

import com.indeed.proctor.consumer.AbstractGroups;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.HttpRequestHandler;

public class ShowGroupsHandler
implements HttpRequestHandler {
    private GroupsSupplier groupsSupplier;

    public ShowGroupsHandler(GroupsSupplier groupSupplier) {
        this.groupsSupplier = groupSupplier;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain;charset=UTF-8");
        PrintWriter writer = response.getWriter();
        AbstractGroups grps = this.groupsSupplier.determineGroups(request);
        if (grps == null) {
            writer.println("Did not determine any groups");
        } else {
            StringBuilder sb = new StringBuilder();
            grps.appendTestGroups(sb, '\n');
            writer.print(sb.toString());
        }
    }

    public static interface GroupsSupplier {
        public AbstractGroups determineGroups(HttpServletRequest var1);
    }
}

