/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.spring;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.consumer.spring.ShowHandlerParamUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.HttpRequestHandler;

public class ShowTestMatrixHandler
implements HttpRequestHandler {
    private final List<Supplier<Proctor>> proctorSuppliers;

    public ShowTestMatrixHandler(Supplier<Proctor> proctorSupplier) {
        this.proctorSuppliers = ImmutableList.of(proctorSupplier);
    }

    public ShowTestMatrixHandler(List<Supplier<Proctor>> proctorSuppliers) {
        this.proctorSuppliers = ImmutableList.copyOf(proctorSuppliers);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain;charset=UTF-8");
        Collection<String> testNameFilter = ShowHandlerParamUtil.getTestQueryParameters(request);
        PrintWriter writer = response.getWriter();
        if (this.proctorSuppliers.isEmpty()) {
            writer.print("No Proctor instances found.");
            return;
        }
        for (Supplier<Proctor> proctorSupplier : this.proctorSuppliers) {
            Proctor proctor = (Proctor)proctorSupplier.get();
            if (proctor == null) {
                writer.println("Did not determine a Proctor instance");
                continue;
            }
            if (testNameFilter != null) {
                proctor.appendTestMatrixFiltered((Writer)writer, testNameFilter);
                continue;
            }
            proctor.appendTestMatrix((Writer)writer);
        }
    }
}

