/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.spring;

import com.google.common.base.Supplier;
import com.indeed.proctor.common.AbstractProctorLoader;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.consumer.spring.ShowGroupsHandler;
import com.indeed.proctor.consumer.spring.ShowRandomGroupsHandler;
import com.indeed.proctor.consumer.spring.ShowTestMatrixHandler;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.bind.annotation.RequestMapping;

public abstract class AbstractShowTestGroupsController
implements ShowGroupsHandler.GroupsSupplier {
    private final ShowGroupsHandler showGroupsHandler = new ShowGroupsHandler(this);
    private final ShowRandomGroupsHandler randomGroupsHandler;
    private final ShowTestMatrixHandler showTestMatrixHandler;

    public AbstractShowTestGroupsController(AbstractProctorLoader proctorSupplier) {
        this.randomGroupsHandler = new ShowRandomGroupsHandler((Supplier<Proctor>)proctorSupplier);
        this.showTestMatrixHandler = new ShowTestMatrixHandler((Supplier<Proctor>)proctorSupplier);
    }

    @RequestMapping(value={"/showGroups"})
    public void showGroups(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.handle(request, response, this.showGroupsHandler);
    }

    @RequestMapping(value={"/showRandomGroups"})
    public void showRandomGroups(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.handle(request, response, this.randomGroupsHandler);
    }

    @RequestMapping(value={"/showTestMatrix"})
    public void showTestMatrix(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.handle(request, response, this.showTestMatrixHandler);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response, HttpRequestHandler handler) throws IOException, ServletException {
        if (this.isAccessAllowed(request)) {
            handler.handleRequest(request, response);
        } else {
            response.sendError(this.getAccessDeniedStatusCode());
        }
    }

    public abstract boolean isAccessAllowed(HttpServletRequest var1);

    protected int getAccessDeniedStatusCode() {
        return HttpStatus.NOT_FOUND.value();
    }
}

