/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.dynamic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.indeed.proctor.common.dynamic.DynamicFilter;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.CollectionUtils;

@JsonTypeName(value="meta_tags_filter")
public class MetaTagsFilter
implements DynamicFilter {
    private final Set<String> metaTags;

    public MetaTagsFilter(@JsonProperty(value="meta_tags") Set<String> metaTags) {
        Preconditions.checkArgument((!CollectionUtils.isEmpty(metaTags) ? 1 : 0) != 0, (Object)"meta_tags should be non-empty string list.");
        this.metaTags = ImmutableSet.copyOf(metaTags);
    }

    @JsonProperty(value="meta_tags")
    public Set<String> getMetaTags() {
        return this.metaTags;
    }

    @Override
    public boolean matches(String testName, ConsumableTestDefinition testDefinition) {
        boolean isMatched = testDefinition.getMetaTags().stream().anyMatch(this.metaTags::contains);
        testDefinition.setDynamic(isMatched);
        return isMatched;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaTagsFilter that = (MetaTagsFilter)o;
        return this.metaTags.equals(that.metaTags);
    }

    public int hashCode() {
        return Objects.hash(this.metaTags);
    }
}

