/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.indeed.proctor.common.AbstractProctorLoader;
import com.indeed.proctor.common.IdentifierValidator;
import com.indeed.proctor.common.JsonParserUtils;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.TestMatrixOutdatedException;
import com.indeed.proctor.common.model.Audit;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.shaded.javax.el7.FunctionMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractJsonProctorLoader
extends AbstractProctorLoader {
    private static final Logger LOGGER = LogManager.getLogger(AbstractJsonProctorLoader.class);
    private static final String TEST_MATRIX_ARTIFACT_JSON_KEY_AUDIT = "audit";
    private static final String TEST_MATRIX_ARTIFACT_JSON_KEY_TESTS = "tests";
    private static final ObjectMapper OBJECT_MAPPER = Serializers.lenient();

    public AbstractJsonProctorLoader(@Nonnull Class<?> cls, @Nonnull ProctorSpecification specification, @Nonnull FunctionMapper functionMapper) {
        super(cls, specification, functionMapper);
    }

    public AbstractJsonProctorLoader(@Nonnull Class<?> cls, @Nonnull ProctorSpecification specification, @Nonnull FunctionMapper functionMapper, @Nonnull IdentifierValidator identifierValidator) {
        super(cls, specification, functionMapper, identifierValidator);
    }

    @CheckForNull
    protected TestMatrixArtifact loadJsonTestMatrix(@Nonnull Reader reader) throws IOException, TestMatrixOutdatedException {
        try {
            TestMatrixArtifact testMatrixArtifact = new TestMatrixArtifact();
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jsonParser = jsonFactory.createParser(reader);
            jsonParser.nextToken();
            JsonParserUtils.consumeJson(jsonParser, (key, parser) -> {
                switch (key) {
                    case "audit": {
                        Preconditions.checkState((parser.currentToken() == JsonToken.START_OBJECT ? 1 : 0) != 0);
                        testMatrixArtifact.setAudit((Audit)OBJECT_MAPPER.readValue(parser, Audit.class));
                        break;
                    }
                    case "tests": {
                        Preconditions.checkState((parser.currentToken() == JsonToken.START_OBJECT ? 1 : 0) != 0);
                        testMatrixArtifact.setTests(this.extractReferencedTests(parser));
                        break;
                    }
                    default: {
                        LOGGER.warn("Unknown test matrix artifact json key: '" + key + "'");
                        parser.skipChildren();
                    }
                }
            });
            Preconditions.checkNotNull((Object)testMatrixArtifact.getAudit(), (Object)"Field \"audit\" was not found in json");
            Preconditions.checkNotNull(testMatrixArtifact.getTests(), (Object)"Field \"tests\" was not found in json");
            TestMatrixArtifact testMatrixArtifact2 = testMatrixArtifact;
            return testMatrixArtifact2;
        }
        catch (IOException e) {
            LOGGER.error("Unable to load test matrix from " + this.getSource(), (Throwable)e);
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Suppressing throwable thrown when closing " + reader, (Throwable)e);
                }
            }
        }
    }

    protected Map<String, ConsumableTestDefinition> extractReferencedTests(@Nonnull JsonParser jsonParser) throws IOException {
        HashMap<String, ConsumableTestDefinition> tests = new HashMap<String, ConsumableTestDefinition>();
        JsonParserUtils.consumeJson(jsonParser, (testName, parser) -> {
            ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)OBJECT_MAPPER.readValue(jsonParser, ConsumableTestDefinition.class);
            if (this.isTestReferenced(testName, testDefinition)) {
                tests.put(testName, testDefinition);
            }
        });
        return tests;
    }

    protected boolean isTestReferenced(String testName, ConsumableTestDefinition testDefinition) {
        if (((Map)Preconditions.checkNotNull((Object)this.requiredTests)).containsKey(testName)) {
            return true;
        }
        if (testDefinition == null) {
            return false;
        }
        return this.dynamicFilters.matches(testName, testDefinition);
    }
}

