/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.collect.Lists;
import com.indeed.proctor.common.InvalidRuleException;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.shaded.javax.el7.ELContext;
import com.indeed.shaded.javax.el7.ELException;
import com.indeed.shaded.javax.el7.ExpressionFactory;
import com.indeed.shaded.javax.el7.ValueExpression;
import com.indeed.shaded.org.apache.el7.lang.ExpressionBuilder;
import com.indeed.shaded.org.apache.el7.parser.AstIdentifier;
import com.indeed.shaded.org.apache.el7.parser.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuleVerifyUtils {
    private static final Logger LOGGER = LogManager.getLogger(RuleVerifyUtils.class);

    private RuleVerifyUtils() {
    }

    public static void verifyRule(String testRule, boolean shouldEvaluate, ExpressionFactory expressionFactory, ELContext elContext, Set<String> absentIdentifiers) throws InvalidRuleException {
        if (!ProctorUtils.isEmptyElExpression(testRule)) {
            ValueExpression valueExpression;
            try {
                valueExpression = expressionFactory.createValueExpression(elContext, testRule, Boolean.class);
            }
            catch (ELException e) {
                throw new InvalidRuleException(e, String.format("Unable to evaluate rule %s due to a syntax error. Check that your rule is in the correct format and returns a boolean. For more information read: https://opensource.indeedeng.io/proctor/docs/test-rules/.", testRule));
            }
            if (shouldEvaluate) {
                Node root;
                try {
                    root = ExpressionBuilder.createNode(testRule);
                }
                catch (ELException e) {
                    throw new InvalidRuleException(e, String.format("Unable to evaluate rule %s due to a syntax error. Check that your rule is in the correct format and returns a boolean. For more information read: https://opensource.indeedeng.io/proctor/docs/test-rules/.", testRule));
                }
                Node undefinedIdentifier = RuleVerifyUtils.checkUndefinedIdentifier(root, elContext, absentIdentifiers);
                if (undefinedIdentifier != null) {
                    throw new InvalidRuleException(String.format("The variable %s is defined in rule %s, however it is not defined in the application's test specification. Add the variable to your application's providedContext.json or remove it from the rule, or if the application should not load your test report the issue to the Proctor team.", undefinedIdentifier.getImage(), testRule));
                }
                try {
                    try {
                        RuleEvaluator.checkRuleIsBooleanType(testRule, elContext, valueExpression);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidRuleException(e, String.format("Unable to evaluate rule %s due to a syntax error. Check that your rule is in the correct format and returns a boolean. For more information read: https://opensource.indeedeng.io/proctor/docs/test-rules/.", testRule));
                    }
                    valueExpression.getValue(elContext);
                }
                catch (ELException e) {
                    if (RuleVerifyUtils.isIgnorable(root, absentIdentifiers)) {
                        LOGGER.debug(String.format("Rule %s contains uninstantiated identifier(s) in %s, ignoring the failure", testRule, absentIdentifiers));
                    }
                    throw new InvalidRuleException(e, String.format("Failed to evaluate a rule %s: " + e.getMessage(), testRule));
                }
            }
        }
    }

    private static boolean isIgnorable(Node node, Set<String> absentIdentifiers) {
        List<Node> leaves = RuleVerifyUtils.getLeafNodes(node);
        for (Node n : leaves) {
            String image = n.getImage();
            if (!absentIdentifiers.contains(image)) continue;
            return true;
        }
        return false;
    }

    private static Node checkUndefinedIdentifier(Node node, ELContext elContext, Set<String> absentIdentifiers) {
        if (node instanceof AstIdentifier) {
            boolean hasVariable;
            String name = node.getImage();
            boolean bl = hasVariable = elContext.getVariableMapper().resolveVariable(name) != null;
            if (!hasVariable && !absentIdentifiers.contains(name)) {
                return node;
            }
        } else {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                Node result = RuleVerifyUtils.checkUndefinedIdentifier(node.jjtGetChild(i), elContext, absentIdentifiers);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static List<Node> getLeafNodes(Node node) {
        ArrayList nodes = Lists.newArrayList();
        RuleVerifyUtils.find(node, nodes);
        return nodes;
    }

    private static void find(Node node, List<Node> res) {
        if (node.jjtGetNumChildren() > 0) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                RuleVerifyUtils.find(node.jjtGetChild(i), res);
            }
        } else {
            res.add(node);
        }
    }
}

