/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Payload {
    @Nullable
    private Double doubleValue;
    @Nullable
    private Double[] doubleArray;
    @Nullable
    private Long longValue;
    @Nullable
    private Long[] longArray;
    @Nullable
    private String stringValue;
    @Nullable
    private String[] stringArray;
    @Nullable
    private Map<String, Object> map;
    public static final Payload EMPTY_PAYLOAD = new Payload();
    public static final String PAYLOAD_NULL_VALUE_EXCEPTION = "Payload map values can't be null: ";
    public static final String PAYLOAD_OVERWRITE_EXCEPTION = "Expected all properties to be empty: ";

    public Payload() {
    }

    public Payload(@Nonnull Payload other) {
        this.doubleValue = other.doubleValue;
        if (other.doubleArray != null) {
            this.doubleArray = Arrays.copyOf(other.doubleArray, other.doubleArray.length);
        }
        this.longValue = other.longValue;
        if (other.longArray != null) {
            this.longArray = Arrays.copyOf(other.longArray, other.longArray.length);
        }
        this.stringValue = other.stringValue;
        if (other.stringArray != null) {
            this.stringArray = Arrays.copyOf(other.stringArray, other.stringArray.length);
        }
        if (other.map != null) {
            this.map = Maps.newHashMap(other.map);
        }
    }

    @Nullable
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(@Nullable Double doubleValue) {
        this.precheckStateAllNull();
        this.doubleValue = doubleValue;
    }

    @Nullable
    public Double[] getDoubleArray() {
        return this.doubleArray;
    }

    public void setDoubleArray(@Nullable Double[] doubleArray) {
        this.precheckStateAllNull();
        this.doubleArray = doubleArray;
    }

    @Nullable
    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(@Nullable Long longValue) {
        this.precheckStateAllNull();
        this.longValue = longValue;
    }

    @Nullable
    public Long[] getLongArray() {
        return this.longArray;
    }

    public void setLongArray(@Nullable Long[] longArray) {
        this.precheckStateAllNull();
        this.longArray = longArray;
    }

    @Nullable
    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(@Nullable String stringValue) {
        this.precheckStateAllNull();
        this.stringValue = stringValue;
    }

    @Nullable
    public String[] getStringArray() {
        return this.stringArray;
    }

    public void setStringArray(@Nullable String[] stringArray) {
        this.precheckStateAllNull();
        this.stringArray = stringArray;
    }

    @Nullable
    public Map<String, Object> getMap() {
        return this.map;
    }

    public void setMap(@Nullable Map<String, Object> map) {
        this.precheckStateAllNull();
        Payload.precheckValidMapValues(map);
        this.map = map;
    }

    private void precheckStateAllNull() throws IllegalStateException {
        if (this.doubleValue != null || this.doubleArray != null || this.longValue != null || this.longArray != null || this.stringValue != null || this.stringArray != null || this.map != null) {
            throw new IllegalStateException(PAYLOAD_OVERWRITE_EXCEPTION + this);
        }
    }

    private static void precheckValidMapValues(@Nullable Map<String, Object> map) throws IllegalStateException {
        if (map != null && map.containsValue(null)) {
            throw new IllegalStateException(PAYLOAD_NULL_VALUE_EXCEPTION + map);
        }
    }

    @Nonnull
    public String toString() {
        StringBuilder s = new StringBuilder(50).append('{');
        if (this.map != null) {
            s.append(" map : [");
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                s.append('(').append(entry.getKey()).append(',').append(entry.getValue()).append(')');
            }
            s.append(']');
        }
        if (this.doubleValue != null) {
            s.append(" doubleValue : ").append(this.doubleValue);
        }
        if (this.doubleArray != null) {
            s.append(" doubleArray : [");
            s.append(StringUtils.join((Object[])this.doubleArray, (String)", "));
            s.append(']');
        }
        if (this.longValue != null) {
            s.append(" longValue : ").append(this.longValue);
        }
        if (this.longArray != null) {
            s.append(" longArray : [");
            s.append(StringUtils.join((Object[])this.longArray, (String)", "));
            s.append(']');
        }
        if (this.stringValue != null) {
            s.append(" stringValue : \"").append(this.stringValue).append('\"');
        }
        if (this.stringArray != null) {
            s.append(" stringArray : [");
            if (this.stringArray.length > 0) {
                s.append('\"');
                s.append(String.join((CharSequence)"\", \"", this.stringArray));
                s.append('\"');
            }
            s.append(']');
        }
        s.append(" }");
        return s.toString();
    }

    @Nonnull
    public String fetchType() {
        if (this.doubleValue != null) {
            return "doubleValue";
        }
        if (this.doubleArray != null) {
            return "doubleArray";
        }
        if (this.longValue != null) {
            return "longValue";
        }
        if (this.longArray != null) {
            return "longArray";
        }
        if (this.stringValue != null) {
            return "stringValue";
        }
        if (this.stringArray != null) {
            return "stringArray";
        }
        if (this.map != null) {
            return "map";
        }
        return "none";
    }

    public boolean sameType(@Nullable Payload that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        return this.doubleValue == null == (that.doubleValue == null) && this.doubleArray == null == (that.doubleArray == null) && this.longValue == null == (that.longValue == null) && this.longArray == null == (that.longArray == null) && this.stringValue == null == (that.stringValue == null) && this.stringArray == null == (that.stringArray == null) && this.map == null == (that.map == null);
    }

    public int numFieldsDefined() {
        int i = 0;
        if (this.map != null) {
            ++i;
        }
        if (this.doubleValue != null) {
            ++i;
        }
        if (this.doubleArray != null) {
            ++i;
        }
        if (this.longValue != null) {
            ++i;
        }
        if (this.longArray != null) {
            ++i;
        }
        if (this.stringValue != null) {
            ++i;
        }
        if (this.stringArray != null) {
            ++i;
        }
        return i;
    }

    @Nullable
    public Object fetchAValue() {
        if (this.doubleValue != null) {
            return this.doubleValue;
        }
        if (this.doubleArray != null) {
            return this.doubleArray;
        }
        if (this.longValue != null) {
            return this.longValue;
        }
        if (this.longArray != null) {
            return this.longArray;
        }
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.stringArray != null) {
            return this.stringArray;
        }
        if (this.map != null) {
            return this.map;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payload payload = (Payload)o;
        return Objects.equals(this.doubleValue, payload.doubleValue) && Arrays.equals((Object[])this.doubleArray, (Object[])payload.doubleArray) && Objects.equals(this.longValue, payload.longValue) && Arrays.equals((Object[])this.longArray, (Object[])payload.longArray) && Objects.equals(this.stringValue, payload.stringValue) && Arrays.equals(this.stringArray, payload.stringArray) && Objects.equals(this.map, payload.map);
    }

    public int hashCode() {
        int result = Objects.hash(this.doubleValue, this.longValue, this.stringValue, this.map);
        result = 31 * result + Arrays.hashCode((Object[])this.doubleArray);
        result = 31 * result + Arrays.hashCode((Object[])this.longArray);
        result = 31 * result + Arrays.hashCode(this.stringArray);
        return result;
    }
}

