/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.collect.ImmutableMap;
import com.indeed.proctor.common.ForceGroupsDefaultMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class ForceGroupsOptions {
    private static final ForceGroupsOptions EMPTY = ForceGroupsOptions.builder().build();
    private final Map<String, Integer> forceGroups;
    private final ForceGroupsDefaultMode defaultMode;

    private ForceGroupsOptions(Builder builder) {
        this.forceGroups = ImmutableMap.copyOf((Map)builder.forceGroups);
        this.defaultMode = builder.defaultMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ForceGroupsOptions empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public Map<String, Integer> getForceGroups() {
        return this.forceGroups;
    }

    public Optional<Integer> getForcedBucketValue(String testName) {
        return Optional.ofNullable(this.forceGroups.get(testName));
    }

    public ForceGroupsDefaultMode getDefaultMode() {
        return this.defaultMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForceGroupsOptions that = (ForceGroupsOptions)o;
        return Objects.equals(this.forceGroups, that.forceGroups) && this.defaultMode == that.defaultMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.forceGroups, this.defaultMode});
    }

    public String toString() {
        return new StringJoiner(", ", ForceGroupsOptions.class.getSimpleName() + "[", "]").add("forceGroups=" + this.forceGroups).add("defaultMode=" + (Object)((Object)this.defaultMode)).toString();
    }

    public static class Builder {
        private final Map<String, Integer> forceGroups = new HashMap<String, Integer>();
        private ForceGroupsDefaultMode defaultMode = ForceGroupsDefaultMode.getInitial();

        public Builder putForceGroup(String testName, int bucketValue) {
            this.forceGroups.put(testName, bucketValue);
            return this;
        }

        public Builder putAllForceGroups(Map<? extends String, ? extends Integer> values) {
            this.forceGroups.putAll(values);
            return this;
        }

        public Builder setDefaultMode(ForceGroupsDefaultMode defaultMode) {
            this.defaultMode = defaultMode;
            return this;
        }

        public ForceGroupsOptions build() {
            return new ForceGroupsOptions(this);
        }
    }
}

