/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.ForceGroupsDefaultMode;
import com.indeed.proctor.common.ForceGroupsOptions;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForceGroupsOptionsStrings {
    private static final Logger LOGGER = LogManager.getLogger(ForceGroupsOptionsStrings.class);

    private ForceGroupsOptionsStrings() {
    }

    @Nonnull
    public static ForceGroupsOptions parseForceGroupsString(@Nullable String forceGroupsString) {
        String[] pieces;
        ForceGroupsOptions.Builder builder = ForceGroupsOptions.builder();
        if (forceGroupsString == null) {
            return builder.build();
        }
        for (String rawPiece : pieces = forceGroupsString.split(",")) {
            int bucketValueStart;
            String piece = rawPiece.trim();
            if (piece.isEmpty()) continue;
            ForceGroupsDefaultMode.fromToken(piece).ifPresent(builder::setDefaultMode);
            for (bucketValueStart = piece.length() - 1; bucketValueStart >= 0 && Character.isDigit(piece.charAt(bucketValueStart)); --bucketValueStart) {
            }
            if (bucketValueStart == piece.length() - 1 || bucketValueStart < 1) continue;
            if (piece.charAt(bucketValueStart) != '-') {
                ++bucketValueStart;
            }
            String testName = piece.substring(0, bucketValueStart).trim();
            String bucketValueStr = piece.substring(bucketValueStart);
            try {
                Integer bucketValue = Integer.valueOf(bucketValueStr);
                builder.putForceGroup(testName, bucketValue);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Unable to parse bucket value " + bucketValueStr + " as integer", (Throwable)e);
            }
        }
        return builder.build();
    }

    public static String generateForceGroupsString(ForceGroupsOptions options) {
        ArrayList tokens = new ArrayList();
        options.getDefaultMode().getToken().ifPresent(tokens::add);
        options.getForceGroups().forEach((testName, bucketValue) -> tokens.add(testName + bucketValue));
        return String.join((CharSequence)",", tokens);
    }
}

