/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.indeed.proctor.common.model.Payload;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class TestBucket {
    @Nonnull
    private String name = "";
    private int value;
    @Nullable
    private String description;
    @Nullable
    private Payload payload;

    public TestBucket() {
    }

    public TestBucket(@Nonnull String name, int value, @Nullable String description) {
        this.name = name;
        this.value = value;
        this.description = description;
        this.payload = null;
    }

    public TestBucket(@Nonnull String name, int value, @Nullable String description, @Nullable Payload payload) {
        this.name = name;
        this.value = value;
        this.description = description;
        this.payload = payload;
    }

    public TestBucket(@Nonnull TestBucket other) {
        this.name = other.name;
        this.value = other.value;
        this.description = other.description;
        if (other.payload != null) {
            this.payload = new Payload(other.payload);
        }
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = Strings.nullToEmpty((String)name);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nullable
    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(@Nullable Payload payload) {
        this.payload = payload;
    }

    @Nullable
    public String toString() {
        return this.name + " = " + this.value + (this.payload == null ? "" : " " + this.payload);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.name.equals(((TestBucket)obj).name);
    }

    boolean fullEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestBucket that = (TestBucket)o;
        return this.value == that.value && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.payload, (Object)that.payload);
    }

    public int fullHashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.value, this.description, this.payload});
    }
}

