/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class NameObfuscator {
    public String obfuscateTestName(String stringToHash) {
        return this.sha256Hash(stringToHash);
    }

    private String sha256Hash(String stringToHash) {
        byte[] encodedHash = NameObfuscator.getSha256MessageDigest().digest(stringToHash.getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder(64);
        for (byte b : encodedHash) {
            if ((0xFF & b) < 16) {
                hexString.append('0').append(Integer.toHexString(0xFF & b));
                continue;
            }
            hexString.append(Integer.toHexString(0xFF & b));
        }
        return hexString.toString();
    }

    private static MessageDigest getSha256MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot initialize SHA-256 hasher", e);
        }
    }
}

