/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.AbstractJsonProctorLoader;
import com.indeed.proctor.common.MissingTestMatrixException;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.TestMatrixOutdatedException;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.shaded.javax.el7.FunctionMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.Nonnull;

public class ClasspathProctorLoader
extends AbstractJsonProctorLoader {
    @Nonnull
    private final String resourcePath;

    public ClasspathProctorLoader(ProctorSpecification specification, @Nonnull String resourcePath, @Nonnull FunctionMapper functionMapper) {
        super(ClasspathProctorLoader.class, specification, functionMapper);
        this.resourcePath = resourcePath;
    }

    @Override
    @Nonnull
    protected String getSource() {
        return this.resourcePath;
    }

    @Override
    protected TestMatrixArtifact loadTestMatrix() throws IOException, MissingTestMatrixException, TestMatrixOutdatedException {
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath);
        if (resourceAsStream == null) {
            throw new MissingTestMatrixException("Could not load proctor test matrix from classpath: " + this.resourcePath);
        }
        InputStreamReader reader = new InputStreamReader(resourceAsStream);
        return this.loadJsonTestMatrix(reader);
    }
}

