/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.indeed.proctor.common.ForceGroupsDefaultMode;
import com.indeed.proctor.common.ForceGroupsOptions;
import com.indeed.proctor.common.PayloadType;
import com.indeed.proctor.common.model.Payload;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForceGroupsOptionsStrings {
    private static final Logger LOGGER = LogManager.getLogger(ForceGroupsOptionsStrings.class);
    private static final int FORCE_PARAMETER_BUCKET_IDX = 0;
    private static final int FORCE_PARAMETER_PAYLOAD_IDX = 1;
    private static final int FORCE_PARAMETER_MAX_SIZE = 2;
    private static final String REGEX_STRING_OR_NUM = "-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"";
    private static final String REGEX_ARRAY = "\\[(?:\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\")(?:\\s*,\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"))*)?\\]";
    private static final String REGEX_MAP = "\\{(?:\\s*(?:\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"\\s*:\\s*)(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"|\\[(?:\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\")(?:\\s*,\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"))*)?\\])(?:\\s*,\\s*(?:\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"\\s*:\\s*)(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"|\\[(?:\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\")(?:\\s*,\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"))*)?\\]))*)?\\}";
    private static final Pattern PATTERN = Pattern.compile("\\w+-?\\d+(?:;\\w+:(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"|\\[(?:\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\")(?:\\s*,\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"))*)?\\]|\\{(?:\\s*(?:\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"\\s*:\\s*)(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"|\\[(?:\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\")(?:\\s*,\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"))*)?\\])(?:\\s*,\\s*(?:\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"\\s*:\\s*)(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"|\\[(?:\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\")(?:\\s*,\\s*(?:-?\\d+\\.?\\d*|\\\"(?:\\\\.|[^\\\"\\\\]+)*\\\"))*)?\\]))*)?\\}))?|[a-z_]+");
    private static final TypeReference<Map<String, Object>> TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    private ForceGroupsOptionsStrings() {
    }

    @Nonnull
    public static ForceGroupsOptions parseForceGroupsString(@Nullable String forceGroupsString) {
        return ForceGroupsOptionsStrings.parseForceGroupsString(forceGroupsString, Collections.emptySet());
    }

    @Nonnull
    public static ForceGroupsOptions parseForceGroupsString(@Nullable String forceGroupsString, Set<String> forcePayloadTests) {
        ForceGroupsOptions.Builder builder = ForceGroupsOptions.builder();
        if (forceGroupsString == null) {
            return builder.build();
        }
        Matcher matcher = PATTERN.matcher(forceGroupsString);
        while (matcher.find()) {
            String match;
            String[] bucketAndPayloadValuesStr;
            String groupString;
            int endOfMatch = matcher.end();
            if (endOfMatch < forceGroupsString.length() && forceGroupsString.charAt(endOfMatch) != ',' || (groupString = (bucketAndPayloadValuesStr = (match = matcher.group()).split(";", 2))[0].trim()).isEmpty()) continue;
            ForceGroupsDefaultMode.fromToken(groupString).ifPresent(builder::setDefaultMode);
            Optional<Integer> bucketValueStart = ForceGroupsOptionsStrings.getBucketValueStart(groupString);
            if (!bucketValueStart.isPresent()) continue;
            String testName = groupString.substring(0, bucketValueStart.get()).trim();
            String bucketValueStr = groupString.substring(bucketValueStart.get()).trim();
            try {
                Payload payloadValue;
                Integer bucketValue = Integer.valueOf(bucketValueStr);
                builder.putForceGroup(testName, bucketValue);
                if (bucketAndPayloadValuesStr.length != 2 || !forcePayloadTests.contains(testName) || (payloadValue = ForceGroupsOptionsStrings.parseForcePayloadString(bucketAndPayloadValuesStr[1])) == null) continue;
                builder.putForcePayload(testName, payloadValue);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Unable to parse bucket value " + bucketValueStr + " as integer", (Throwable)e);
            }
        }
        return builder.build();
    }

    private static Optional<Integer> getBucketValueStart(String groupString) {
        int bucketValueStart;
        for (bucketValueStart = groupString.length() - 1; bucketValueStart >= 0 && Character.isDigit(groupString.charAt(bucketValueStart)); --bucketValueStart) {
        }
        if (bucketValueStart == groupString.length() - 1 || bucketValueStart < 1) {
            return Optional.empty();
        }
        if (groupString.charAt(bucketValueStart) != '-') {
            ++bucketValueStart;
        }
        return Optional.of(bucketValueStart);
    }

    @Nullable
    public static Payload parseForcePayloadString(String payloadString) {
        Payload payload = new Payload();
        String[] payloadPieces = payloadString.split(":", 2);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            PayloadType payloadType = PayloadType.payloadTypeForName(payloadPieces[0]);
            String payloadValue = payloadPieces[1];
            switch (payloadType) {
                case DOUBLE_VALUE: {
                    payload.setDoubleValue((Double)objectMapper.readValue(payloadValue, Double.class));
                    break;
                }
                case DOUBLE_ARRAY: {
                    payload.setDoubleArray((Double[])objectMapper.readValue(payloadValue, Double[].class));
                    break;
                }
                case LONG_VALUE: {
                    payload.setLongValue((Long)objectMapper.readValue(payloadValue, Long.class));
                    break;
                }
                case LONG_ARRAY: {
                    payload.setLongArray((Long[])objectMapper.readValue(payloadValue, Long[].class));
                    break;
                }
                case STRING_VALUE: {
                    payload.setStringValue((String)objectMapper.readValue(payloadValue, String.class));
                    break;
                }
                case STRING_ARRAY: {
                    payload.setStringArray((String[])objectMapper.readValue(payloadValue, String[].class));
                    break;
                }
                case MAP: {
                    payload.setMap((Map)objectMapper.readValue(payloadValue, TYPE_REFERENCE));
                    break;
                }
                case JSON: {
                    return null;
                }
            }
        }
        catch (IOException | ArrayStoreException | ClassCastException | IllegalArgumentException e) {
            return null;
        }
        return payload;
    }

    public static String generateForceGroupsString(ForceGroupsOptions options) {
        ArrayList tokens = new ArrayList();
        options.getDefaultMode().getToken().ifPresent(tokens::add);
        Map<String, Payload> forcePayloads = options.getForcePayloads();
        options.getForceGroups().forEach((testName, bucketValue) -> tokens.add(forcePayloads.containsKey(testName) ? testName + bucketValue + ";" + ForceGroupsOptionsStrings.createForcePayloadString((Payload)forcePayloads.get(testName)) : testName + bucketValue));
        return String.join((CharSequence)",", tokens);
    }

    @Nonnull
    private static String createForcePayloadString(Payload payload) {
        StringBuilder s = new StringBuilder(50);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            if (payload.getDoubleValue() != null) {
                String doubleValue = objectMapper.writeValueAsString((Object)payload.getDoubleValue());
                s.append("doubleValue:").append(doubleValue);
            }
            if (payload.getDoubleArray() != null) {
                String doubleArray = objectMapper.writeValueAsString((Object)payload.getDoubleArray());
                s.append("doubleArray:").append(doubleArray);
            }
            if (payload.getLongValue() != null) {
                String longValue = objectMapper.writeValueAsString((Object)payload.getLongValue());
                s.append("longValue:").append(longValue);
            }
            if (payload.getLongArray() != null) {
                String longArray = objectMapper.writeValueAsString((Object)payload.getLongArray());
                s.append("longArray:").append(longArray);
            }
            if (payload.getStringValue() != null) {
                String stringValue = objectMapper.writeValueAsString((Object)payload.getStringValue());
                s.append("stringValue:").append(stringValue);
            }
            if (payload.getStringArray() != null) {
                String stringArray = objectMapper.writeValueAsString((Object)payload.getStringArray());
                s.append("stringArray:").append(stringArray);
            }
            if (payload.getMap() != null) {
                String mapValue = objectMapper.writeValueAsString(payload.getMap());
                s.append("map:").append(mapValue);
            }
            return s.toString();
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }
}

