/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.AbstractJsonProctorLoader;
import com.indeed.proctor.common.MissingTestMatrixException;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.shaded.javax.el7.FunctionMapper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileProctorLoader
extends AbstractJsonProctorLoader {
    @Nonnull
    private final File inputFile;

    public FileProctorLoader(@Nonnull ProctorSpecification specification, @Nonnull String inputFile, @Nonnull FunctionMapper functionMapper) {
        this(specification, new File(inputFile), functionMapper);
    }

    public FileProctorLoader(@Nonnull ProctorSpecification specification, @Nonnull File inputFile, @Nonnull FunctionMapper functionMapper) {
        super(FileProctorLoader.class, specification, functionMapper);
        this.inputFile = inputFile;
    }

    @Override
    @Nonnull
    protected String getSource() {
        return this.inputFile.getAbsolutePath();
    }

    @Override
    @Nullable
    protected TestMatrixArtifact loadTestMatrix() throws IOException, MissingTestMatrixException {
        if (!this.inputFile.exists()) {
            throw new MissingTestMatrixException("File " + this.inputFile + " does not exist");
        }
        if (!this.inputFile.canRead()) {
            throw new MissingTestMatrixException("Cannot read input file " + this.inputFile);
        }
        FileReader reader = new FileReader(this.inputFile);
        return this.loadJsonTestMatrix(reader);
    }
}

