/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.indeed.proctor.common.AbstractProctorLoader;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.shaded.javax.el7.FunctionMapper;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public abstract class AbstractJsonProctorLoader
extends AbstractProctorLoader {
    private static final Logger LOGGER = Logger.getLogger(AbstractJsonProctorLoader.class);
    @Nonnull
    private final ObjectMapper objectMapper = Serializers.lenient();

    public AbstractJsonProctorLoader(@Nonnull Class<?> cls, @Nonnull ProctorSpecification specification, @Nonnull FunctionMapper functionMapper) {
        super(cls, specification, functionMapper);
    }

    @Nullable
    protected TestMatrixArtifact loadJsonTestMatrix(@Nonnull Reader reader) throws IOException {
        try {
            TestMatrixArtifact testMatrixArtifact = (TestMatrixArtifact)this.objectMapper.readValue(reader, TestMatrixArtifact.class);
            return testMatrixArtifact;
        }
        catch (JsonParseException e) {
            LOGGER.error((Object)("Unable to load test matrix from " + this.getSource()), (Throwable)e);
            throw e;
        }
        catch (JsonMappingException e) {
            LOGGER.error((Object)("Unable to load test matrix from " + this.getSource()), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOGGER.error((Object)("Unable to load test matrix from " + this.getSource()), (Throwable)e);
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Suppressing throwable thrown when closing " + reader), (Throwable)e);
                }
            }
        }
    }
}

