/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.model.Payload;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum PayloadType {
    DOUBLE_VALUE("doubleValue", "Double", "number", "getDoubleValue"),
    DOUBLE_ARRAY("doubleArray", "Double[]", "Array.<number>", "getDoubleArray"),
    LONG_VALUE("longValue", "Long", "number", "getLongValue"),
    LONG_ARRAY("longArray", "Long[]", "Array.<number>", "getLongArray"),
    STRING_VALUE("stringValue", "String", "string", "getStringValue"),
    STRING_ARRAY("stringArray", "String[]", "Array.<string>", "getStringArray"),
    MAP("map", "Map<String,Object>", "Object.<string, Object>", "getMap");

    @Nonnull
    public final String payloadTypeName;
    @Nonnull
    public final String javaClassName;
    @Nonnull
    public final String javascriptTypeName;
    @Nonnull
    public final String javaAccessorName;

    private PayloadType(@Nonnull String payloadTypeName, @Nonnull String javaClassName, String javascriptTypeName, String javaAccessorName) {
        this.payloadTypeName = payloadTypeName;
        this.javaClassName = javaClassName;
        this.javascriptTypeName = javascriptTypeName;
        this.javaAccessorName = javaAccessorName;
    }

    public boolean payloadHasThisType(@Nullable Payload payload) {
        if (payload == null) {
            return false;
        }
        switch (this) {
            case DOUBLE_VALUE: {
                return payload.getDoubleValue() != null;
            }
            case DOUBLE_ARRAY: {
                return payload.getDoubleArray() != null;
            }
            case LONG_VALUE: {
                return payload.getLongValue() != null;
            }
            case LONG_ARRAY: {
                return payload.getLongArray() != null;
            }
            case STRING_VALUE: {
                return payload.getStringValue() != null;
            }
            case STRING_ARRAY: {
                return payload.getStringArray() != null;
            }
            case MAP: {
                return payload.getMap() != null;
            }
        }
        throw new IllegalStateException("Unknown payload type: " + (Object)((Object)this));
    }

    public String getDefaultJavascriptValue() {
        switch (this) {
            case DOUBLE_VALUE: 
            case LONG_VALUE: {
                return "-1";
            }
            case STRING_VALUE: {
                return "''";
            }
            case DOUBLE_ARRAY: 
            case LONG_ARRAY: 
            case STRING_ARRAY: {
                return "[]";
            }
            case MAP: {
                return "{}";
            }
        }
        throw new IllegalStateException("Unknown payload type: " + (Object)((Object)this));
    }

    @Nonnull
    public static PayloadType payloadTypeForName(@Nonnull String payloadTypeName) throws IllegalArgumentException {
        for (PayloadType p : PayloadType.values()) {
            if (!payloadTypeName.equals(p.payloadTypeName)) continue;
            return p;
        }
        throw new IllegalArgumentException("Payload type name " + payloadTypeName + " is not in the list of standard values: " + PayloadType.allTypeNames().toString());
    }

    @Nonnull
    public static PayloadType payloadTypeForValue(@Nonnull Object payloadValue) throws IllegalArgumentException {
        if (payloadValue instanceof List) {
            if (((List)payloadValue).size() > 0) {
                Object firstValue = ((List)payloadValue).get(0);
                if (firstValue instanceof Long || firstValue instanceof Integer) {
                    return LONG_ARRAY;
                }
                if (firstValue instanceof Double || firstValue instanceof Float) {
                    return DOUBLE_ARRAY;
                }
                if (firstValue instanceof String) {
                    return STRING_ARRAY;
                }
                throw new IllegalArgumentException("Cannot determine array-type from " + firstValue);
            }
            throw new IllegalArgumentException("No items in payload List, cannot determine type");
        }
        if (payloadValue instanceof Long || payloadValue instanceof Integer) {
            return LONG_VALUE;
        }
        if (payloadValue instanceof Double || payloadValue instanceof Float) {
            return DOUBLE_VALUE;
        }
        if (payloadValue instanceof String) {
            return STRING_VALUE;
        }
        if (payloadValue instanceof String[]) {
            return STRING_ARRAY;
        }
        if (payloadValue instanceof Long[] || payloadValue instanceof Integer[]) {
            return LONG_ARRAY;
        }
        if (payloadValue instanceof Double[] || payloadValue instanceof Float[]) {
            return DOUBLE_ARRAY;
        }
        if (payloadValue instanceof Map) {
            return MAP;
        }
        throw new IllegalArgumentException("Payload value " + payloadValue.getClass().getSimpleName() + " : " + payloadValue + "  does not correspond to a payload type");
    }

    @Nonnull
    public static List<String> allTypeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (PayloadType p : PayloadType.values()) {
            names.add(p.payloadTypeName);
        }
        return names;
    }
}

