/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.AbstractJsonProctorLoader;
import com.indeed.proctor.common.MissingTestMatrixException;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.el.FunctionMapper;

public class UrlProctorLoader
extends AbstractJsonProctorLoader {
    @Nonnull
    private final URL inputURL;

    public UrlProctorLoader(@Nonnull ProctorSpecification specification, @Nonnull String inputUrl) throws MalformedURLException {
        this(specification, new URL(inputUrl));
    }

    public UrlProctorLoader(@Nonnull ProctorSpecification specification, @Nonnull String inputUrl, FunctionMapper functionMapper) throws MalformedURLException {
        this(specification, new URL(inputUrl), functionMapper);
    }

    public UrlProctorLoader(@Nonnull ProctorSpecification specification, @Nonnull URL inputUrl) {
        super(UrlProctorLoader.class, specification, RuleEvaluator.FUNCTION_MAPPER);
        this.inputURL = inputUrl;
    }

    public UrlProctorLoader(@Nonnull ProctorSpecification specification, @Nonnull URL inputUrl, FunctionMapper functionMapper) {
        super(UrlProctorLoader.class, specification, functionMapper);
        this.inputURL = inputUrl;
    }

    @Override
    @Nonnull
    protected String getSource() {
        return this.inputURL.toString();
    }

    @Override
    @Nullable
    protected TestMatrixArtifact loadTestMatrix() throws IOException, MissingTestMatrixException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputURL.openStream()));){
            TestMatrixArtifact testMatrixArtifact = this.loadJsonTestMatrix(reader);
            return testMatrixArtifact;
        }
    }
}

