/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.indeed.proctor.common.IncompatibleTestMatrixException;
import com.indeed.proctor.common.PayloadSpecification;
import com.indeed.proctor.common.PayloadType;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.common.ProctorLoadResult;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.ProvidedContext;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.proctor.common.RuleVerifyUtils;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.TestSpecification;
import com.indeed.proctor.common.el.MulticontextReadOnlyVariableMapper;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.Audit;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Payload;
import com.indeed.proctor.common.model.Range;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestDefinition;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.proctor.common.model.TestMatrixDefinition;
import com.indeed.proctor.common.model.TestMatrixVersion;
import com.indeed.proctor.common.model.TestType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import org.apache.el.ExpressionFactoryImpl;
import org.apache.log4j.Logger;

public abstract class ProctorUtils {
    private static final ObjectMapper OBJECT_MAPPER = Serializers.lenient().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    private static final Logger LOGGER = Logger.getLogger(ProctorUtils.class);

    public static MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Impossible no MD5", e);
        }
    }

    @Nonnull
    public static Map<String, ValueExpression> convertToValueExpressionMap(@Nonnull ExpressionFactory expressionFactory, @Nonnull Map<String, Object> values) {
        HashMap<String, ValueExpression> context = new HashMap<String, ValueExpression>(values.size());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            ValueExpression ve = expressionFactory.createValueExpression(entry.getValue(), Object.class);
            context.put(entry.getKey(), ve);
        }
        return context;
    }

    public static String convertToArtifact(@Nonnull TestMatrixVersion testMatrix) throws IOException {
        StringWriter sw = new StringWriter();
        TestMatrixArtifact artifact = ProctorUtils.convertToConsumableArtifact(testMatrix);
        ProctorUtils.serializeArtifact(sw, artifact);
        return sw.toString();
    }

    public static void serializeArtifact(Writer writer, TestMatrixArtifact artifact) throws IOException {
        ProctorUtils.serializeObject(writer, artifact);
    }

    public static void serializeArtifact(JsonGenerator jsonGenerator, Proctor proctor) throws IOException {
        jsonGenerator.writeObject((Object)proctor.getArtifact());
    }

    public static void serializeTestDefinition(Writer writer, TestDefinition definition) throws IOException {
        ProctorUtils.serializeObject(writer, definition);
    }

    public static JsonNode readJsonFromFile(File input) throws IOException {
        ObjectMapper mapper = Serializers.lenient();
        JsonNode rootNode = (JsonNode)mapper.readValue(input, JsonNode.class);
        return rootNode;
    }

    public static void serializeTestSpecification(Writer writer, TestSpecification specification) throws IOException {
        ProctorUtils.serializeObject(writer, specification);
    }

    private static <T> void serializeObject(Writer writer, T artifact) throws IOException {
        OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue(writer, artifact);
    }

    @Nonnull
    public static TestMatrixArtifact convertToConsumableArtifact(@Nonnull TestMatrixVersion testMatrix) {
        Audit audit = new Audit();
        Date published = (Date)Preconditions.checkNotNull((Object)testMatrix.getPublished(), (Object)"Missing publication date");
        audit.setUpdated(published.getTime());
        audit.setVersion(testMatrix.getVersion());
        audit.setUpdatedBy(testMatrix.getAuthor());
        TestMatrixArtifact artifact = new TestMatrixArtifact();
        artifact.setAudit(audit);
        TestMatrixDefinition testMatrixDefinition = (TestMatrixDefinition)Preconditions.checkNotNull((Object)testMatrix.getTestMatrixDefinition(), (Object)"Missing test matrix definition");
        Map<String, TestDefinition> testDefinitions = testMatrixDefinition.getTests();
        LinkedHashMap consumableTestDefinitions = Maps.newLinkedHashMap();
        for (Map.Entry<String, TestDefinition> entry : testDefinitions.entrySet()) {
            TestDefinition td = entry.getValue();
            ConsumableTestDefinition ctd = ProctorUtils.convertToConsumableTestDefinition(td);
            consumableTestDefinitions.put(entry.getKey(), ctd);
        }
        artifact.setTests(consumableTestDefinitions);
        return artifact;
    }

    @Nonnull
    public static ConsumableTestDefinition convertToConsumableTestDefinition(@Nonnull TestDefinition td) {
        String rule;
        String rawRule;
        Map<String, Object> specialConstants = td.getSpecialConstants();
        ArrayList ruleComponents = Lists.newArrayList();
        List countries = (List)specialConstants.get("__COUNTRIES");
        if (countries != null) {
            ruleComponents.add("proctor:contains(__COUNTRIES, country)");
        }
        if (!ProctorUtils.isEmptyWhitespace(rawRule = ProctorUtils.removeElExpressionBraces(td.getRule()))) {
            ruleComponents.add(rawRule);
        }
        if (ruleComponents.isEmpty()) {
            rule = null;
        } else {
            StringBuilder ruleBuilder = new StringBuilder("${");
            for (int i = 0; i < ruleComponents.size(); ++i) {
                if (i != 0) {
                    ruleBuilder.append(" && ");
                }
                ruleBuilder.append((String)ruleComponents.get(i));
            }
            ruleBuilder.append("}");
            rule = ruleBuilder.toString();
        }
        List<Allocation> allocations = td.getAllocations();
        for (Allocation alloc : allocations) {
            String rawAllocRule = ProctorUtils.removeElExpressionBraces(alloc.getRule());
            if (ProctorUtils.isEmptyWhitespace(rawAllocRule)) {
                alloc.setRule(null);
                continue;
            }
            if (rawAllocRule.startsWith("${") && rawAllocRule.endsWith("}")) continue;
            String newAllocRule = "${" + rawAllocRule + "}";
            alloc.setRule(newAllocRule);
        }
        LinkedHashMap constants = Maps.newLinkedHashMap();
        constants.putAll(td.getConstants());
        constants.putAll(specialConstants);
        return new ConsumableTestDefinition(td.getVersion(), rule, td.getTestType(), td.getSalt(), td.getBuckets(), allocations, td.getSilent(), constants, td.getDescription());
    }

    public static ProctorSpecification readSpecification(File inputFile) {
        ProctorSpecification spec;
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(inputFile));
            spec = ProctorUtils.readSpecification(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read test set from " + inputFile, e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Suppressing throwable thrown when closing " + inputFile), (Throwable)e);
                }
            }
        }
        return spec;
    }

    public static ProctorSpecification readSpecification(InputStream inputFile) {
        ProctorSpecification spec;
        try {
            spec = (ProctorSpecification)OBJECT_MAPPER.readValue(inputFile, ProctorSpecification.class);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Unable to read test set from " + inputFile + ": ", e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Unable to read test set from " + inputFile, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read test set from " + inputFile, e);
        }
        return spec;
    }

    public static ProctorLoadResult verifyAndConsolidate(@Nonnull TestMatrixArtifact testMatrix, String matrixSource, @Nonnull Map<String, TestSpecification> requiredTests, @Nonnull FunctionMapper functionMapper) {
        return ProctorUtils.verifyAndConsolidate(testMatrix, matrixSource, requiredTests, functionMapper, new ProvidedContext(ProvidedContext.EMPTY_CONTEXT, false), Collections.emptySet());
    }

    public static ProctorLoadResult verifyAndConsolidate(@Nonnull TestMatrixArtifact testMatrix, String matrixSource, @Nonnull Map<String, TestSpecification> requiredTests, @Nonnull FunctionMapper functionMapper, ProvidedContext providedContext) {
        return ProctorUtils.verifyAndConsolidate(testMatrix, matrixSource, requiredTests, functionMapper, providedContext, Collections.emptySet());
    }

    public static ProctorLoadResult verifyAndConsolidate(@Nonnull TestMatrixArtifact testMatrix, String matrixSource, @Nonnull Map<String, TestSpecification> requiredTests, @Nonnull FunctionMapper functionMapper, ProvidedContext providedContext, @Nonnull Set<String> dynamicTests) {
        ProctorLoadResult result = ProctorUtils.verify(testMatrix, matrixSource, requiredTests, functionMapper, providedContext, dynamicTests);
        Map<String, ConsumableTestDefinition> definedTests = testMatrix.getTests();
        for (String invalidTest : result.getTestsWithErrors()) {
            definedTests.remove(invalidTest);
        }
        for (String invalidDynamicTest : result.getDynamicTestWithErrors()) {
            definedTests.remove(invalidDynamicTest);
        }
        ProctorUtils.consolidate(testMatrix, requiredTests, dynamicTests);
        return result;
    }

    public static ProctorLoadResult verifyWithoutSpecification(@Nonnull TestMatrixArtifact testMatrix, String matrixSource) {
        ProctorLoadResult.Builder resultBuilder = ProctorLoadResult.newBuilder();
        for (Map.Entry<String, ConsumableTestDefinition> entry : testMatrix.getTests().entrySet()) {
            String testName = entry.getKey();
            ConsumableTestDefinition testDefinition = entry.getValue();
            try {
                ProctorUtils.verifyInternallyConsistentDefinition(testName, matrixSource, testDefinition);
            }
            catch (IncompatibleTestMatrixException e) {
                LOGGER.info((Object)String.format("Unable to load test matrix for %s", testName), (Throwable)e);
                resultBuilder.recordError(testName, e);
            }
        }
        return resultBuilder.build();
    }

    public static ProctorLoadResult verify(@Nonnull TestMatrixArtifact testMatrix, String matrixSource, @Nonnull Map<String, TestSpecification> requiredTests) {
        return ProctorUtils.verify(testMatrix, matrixSource, requiredTests, RuleEvaluator.FUNCTION_MAPPER, new ProvidedContext(ProvidedContext.EMPTY_CONTEXT, false), Collections.emptySet());
    }

    public static ProctorLoadResult verify(@Nonnull TestMatrixArtifact testMatrix, String matrixSource, @Nonnull Map<String, TestSpecification> requiredTests, @Nonnull Set<String> dynamicTests) {
        return ProctorUtils.verify(testMatrix, matrixSource, requiredTests, RuleEvaluator.FUNCTION_MAPPER, new ProvidedContext(ProvidedContext.EMPTY_CONTEXT, false), dynamicTests);
    }

    public static ProctorLoadResult verify(@Nonnull TestMatrixArtifact testMatrix, String matrixSource, @Nonnull Map<String, TestSpecification> requiredTests, @Nonnull FunctionMapper functionMapper, ProvidedContext providedContext) {
        return ProctorUtils.verify(testMatrix, matrixSource, requiredTests, functionMapper, providedContext, Collections.emptySet());
    }

    public static ProctorLoadResult verify(@Nonnull TestMatrixArtifact testMatrix, String matrixSource, @Nonnull Map<String, TestSpecification> requiredTests, @Nonnull FunctionMapper functionMapper, ProvidedContext providedContext, @Nonnull Set<String> dynamicTests) {
        ProctorLoadResult.Builder resultBuilder = ProctorLoadResult.newBuilder();
        HashMap allTestsKnownBuckets = Maps.newHashMapWithExpectedSize((int)requiredTests.size());
        for (Map.Entry<String, TestSpecification> entry : requiredTests.entrySet()) {
            HashMap bucketValueToName = Maps.newHashMap();
            for (Map.Entry<String, Integer> bucket : entry.getValue().getBuckets().entrySet()) {
                bucketValueToName.put(bucket.getValue(), bucket.getKey());
            }
            allTestsKnownBuckets.put(entry.getKey(), bucketValueToName);
        }
        Map<String, ConsumableTestDefinition> definedTests = testMatrix.getTests();
        Sets.SetView missingTests = Sets.difference(requiredTests.keySet(), definedTests.keySet());
        resultBuilder.recordAllMissing((Collection<String>)missingTests);
        for (Map.Entry entry : definedTests.entrySet()) {
            TestSpecification specification;
            Map<Integer, String> knownBuckets;
            boolean isRequired;
            String testName = (String)entry.getKey();
            if (allTestsKnownBuckets.containsKey(testName)) {
                isRequired = true;
                knownBuckets = (Map<Integer, String>)allTestsKnownBuckets.remove(testName);
                specification = requiredTests.get(testName);
            } else {
                if (!dynamicTests.contains(testName)) continue;
                isRequired = false;
                knownBuckets = Collections.emptyMap();
                specification = new TestSpecification();
            }
            ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)entry.getValue();
            try {
                ProctorUtils.verifyTest(testName, testDefinition, specification, knownBuckets, matrixSource, functionMapper, providedContext);
            }
            catch (IncompatibleTestMatrixException e) {
                LOGGER.info((Object)String.format("Unable to load test matrix for %s", testName), (Throwable)e);
                if (isRequired) {
                    resultBuilder.recordError(testName, e);
                    continue;
                }
                resultBuilder.recordIncompatibleDynamicTest(testName, e);
            }
        }
        resultBuilder.recordAllMissing(allTestsKnownBuckets.keySet());
        resultBuilder.recordVerifiedRules(providedContext.shouldEvaluate());
        ProctorLoadResult loadResult = resultBuilder.build();
        return loadResult;
    }

    private static void verifyTest(@Nonnull String testName, @Nonnull ConsumableTestDefinition testDefinition, @Nonnull TestSpecification testSpecification, @Nonnull Map<Integer, String> knownBuckets, @Nonnull String matrixSource, @Nonnull FunctionMapper functionMapper) throws IncompatibleTestMatrixException {
        ProctorUtils.verifyTest(testName, testDefinition, testSpecification, knownBuckets, matrixSource, functionMapper, new ProvidedContext(ProvidedContext.EMPTY_CONTEXT, false));
    }

    private static void verifyTest(@Nonnull String testName, @Nonnull ConsumableTestDefinition testDefinition, @Nonnull TestSpecification testSpecification, @Nonnull Map<Integer, String> knownBuckets, @Nonnull String matrixSource, @Nonnull FunctionMapper functionMapper, ProvidedContext providedContext) throws IncompatibleTestMatrixException {
        List<Allocation> allocations = testDefinition.getAllocations();
        TestType declaredType = testDefinition.getTestType();
        if (!TestType.all().contains(declaredType)) {
            throw new IncompatibleTestMatrixException(String.format("Test '%s' is included in the application specification but refers to unknown id type '%s'.", testName, declaredType));
        }
        ProctorUtils.verifyInternallyConsistentDefinition(testName, matrixSource, testDefinition, functionMapper, providedContext);
        if (!testSpecification.getBuckets().isEmpty()) {
            HashSet unknownBuckets = Sets.newHashSet();
            for (Allocation allocation : allocations) {
                List<Range> ranges = allocation.getRanges();
                for (Range range : ranges) {
                    if (knownBuckets.containsKey(range.getBucketValue()) || !(range.getLength() > 0.0)) continue;
                    unknownBuckets.add(range.getBucketValue());
                }
            }
            if (unknownBuckets.size() > 0) {
                throw new IncompatibleTestMatrixException("Allocation range in " + testName + " from " + matrixSource + " refers to unknown bucket value(s) " + unknownBuckets + " with length > 0");
            }
        }
        RuleEvaluator ruleEvaluator = ProctorUtils.makeRuleEvaluator(RuleEvaluator.EXPRESSION_FACTORY, functionMapper);
        PayloadSpecification payloadSpec = testSpecification.getPayload();
        if (payloadSpec != null) {
            String specifiedPayloadTypeName = (String)Preconditions.checkNotNull((Object)payloadSpec.getType(), (Object)"Missing payload spec type");
            PayloadType specifiedPayloadType = PayloadType.payloadTypeForName(specifiedPayloadTypeName);
            Map<String, String> specificationPayloadTypes = payloadSpec.getSchema();
            if (specifiedPayloadType == PayloadType.MAP && (specificationPayloadTypes.isEmpty() || specificationPayloadTypes == null)) {
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected non empty payload");
            }
            if (specifiedPayloadType == null) {
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " test specification payload type unknown: " + specifiedPayloadTypeName);
            }
            String payloadValidatorRule = payloadSpec.getValidator();
            List<TestBucket> buckets = testDefinition.getBuckets();
            for (TestBucket bucket : buckets) {
                boolean payloadIsValid;
                Payload payload = bucket.getPayload();
                if (payload == null) continue;
                if (!specifiedPayloadType.payloadHasThisType(payload)) {
                    throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of type " + specifiedPayloadType.payloadTypeName + " but matrix has a test bucket payload with wrong type: " + bucket);
                }
                if (specifiedPayloadType == PayloadType.MAP) {
                    ProctorUtils.checkMapPayloadTypes(payload, specificationPayloadTypes, matrixSource, testName, specifiedPayloadType, payloadValidatorRule, bucket, functionMapper);
                    continue;
                }
                if (payloadValidatorRule == null || (payloadIsValid = ProctorUtils.evaluatePayloadValidator(ruleEvaluator, payloadValidatorRule, payload))) continue;
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " payload validation rule " + payloadValidatorRule + " failed for test bucket: " + bucket);
            }
        }
    }

    private static void checkMapPayloadTypes(Payload payload, Map<String, String> specificationPayloadTypes, String matrixSource, String testName, PayloadType specifiedPayloadType, String payloadValidatorRule, TestBucket bucket, FunctionMapper functionMapper) throws IncompatibleTestMatrixException {
        boolean payloadIsValid;
        RuleEvaluator ruleEvaluator = ProctorUtils.makeRuleEvaluator(RuleEvaluator.EXPRESSION_FACTORY, functionMapper);
        if (payload.getMap() == null) {
            throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of type " + specifiedPayloadType.payloadTypeName + " but matrix has a test bucket payload with wrong type: " + bucket);
        }
        if (specificationPayloadTypes.size() > payload.getMap().size()) {
            throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of equal size to specification " + (Object)((Object)specifiedPayloadType) + "  but matrix has a test bucket payload with wrong type size: " + bucket);
        }
        Map<String, Object> bucketPayloadMap = payload.getMap();
        for (Map.Entry<String, String> specificationPayloadEntry : specificationPayloadTypes.entrySet()) {
            PayloadType expectedPayloadType;
            if (!bucketPayloadMap.containsKey(specificationPayloadEntry.getKey())) {
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of same order and variable names as specificied in " + (Object)((Object)specifiedPayloadType) + " but matrix has a test bucket payload with wrong type: " + bucket);
            }
            try {
                expectedPayloadType = PayloadType.payloadTypeForName(specificationPayloadEntry.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " specification payload type unknown in: " + specifiedPayloadType.payloadTypeName);
            }
            if (expectedPayloadType == PayloadType.MAP) {
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " specification payload type has unallowed nested map types: " + specifiedPayloadType.payloadTypeName);
            }
            Object actualPayload = bucketPayloadMap.get(specificationPayloadEntry.getKey());
            if (actualPayload instanceof ArrayList) {
                for (Object actualPayloadEntry : (ArrayList)actualPayload) {
                    Class<?> actualClazz = actualPayloadEntry.getClass();
                    if (PayloadType.STRING_ARRAY == expectedPayloadType) {
                        if (String.class.isAssignableFrom(actualClazz)) continue;
                        throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of type " + specifiedPayloadType.payloadTypeName + " but matrix has a test bucket payload with wrong nested type: " + bucket);
                    }
                    if (PayloadType.LONG_ARRAY == expectedPayloadType || PayloadType.DOUBLE_ARRAY == expectedPayloadType) {
                        if (Number.class.isAssignableFrom(actualClazz)) continue;
                        throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of type " + specifiedPayloadType.payloadTypeName + " but matrix has a test bucket payload with wrong nested type: " + bucket);
                    }
                    throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of type " + specifiedPayloadType.payloadTypeName + " but matrix has a test bucket payload with wrong nested type: " + bucket);
                }
                continue;
            }
            if (PayloadType.DOUBLE_ARRAY == expectedPayloadType || PayloadType.STRING_ARRAY == expectedPayloadType || PayloadType.LONG_ARRAY == expectedPayloadType) {
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of type " + specifiedPayloadType.payloadTypeName + " but matrix has a test bucket payload with wrong nested type: " + bucket);
            }
            if (PayloadType.DOUBLE_VALUE == expectedPayloadType || PayloadType.LONG_VALUE == expectedPayloadType) {
                Class<?> actualClazz = actualPayload.getClass();
                if (Number.class.isAssignableFrom(actualClazz)) continue;
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of type " + specifiedPayloadType.payloadTypeName + " but matrix has a test bucket payload with wrong nested type: " + bucket);
            }
            try {
                if (Class.forName("java.lang." + expectedPayloadType.javaClassName).isInstance(actualPayload)) continue;
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of type " + specifiedPayloadType.payloadTypeName + " but matrix has a test bucket payload with wrong nested type: " + bucket);
            }
            catch (ClassNotFoundException e) {
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " incompatible payload type?");
            }
        }
        if (payloadValidatorRule != null && !(payloadIsValid = ProctorUtils.evaluatePayloadMapValidator(ruleEvaluator, payloadValidatorRule, payload))) {
            throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " payload validation rule " + payloadValidatorRule + " failed for test bucket: " + bucket);
        }
    }

    private static void consolidate(@Nonnull TestMatrixArtifact testMatrix, @Nonnull Map<String, TestSpecification> requiredTests, @Nonnull Set<String> dynamicTests) {
        Map<String, ConsumableTestDefinition> definedTests = testMatrix.getTests();
        ImmutableSet toRemove = ImmutableSet.copyOf((Collection)Sets.difference(definedTests.keySet(), (Set)Sets.union(requiredTests.keySet(), dynamicTests)));
        for (String testInMatrixNotRequired : toRemove) {
            definedTests.remove(testInMatrixNotRequired);
        }
        ImmutableSet missing = ImmutableSet.copyOf((Collection)Sets.difference(requiredTests.keySet(), definedTests.keySet()));
        for (String string : missing) {
            definedTests.put(string, ProctorUtils.defaultFor(string, requiredTests.get(string)));
        }
        for (Map.Entry entry : definedTests.entrySet()) {
            String testName = (String)entry.getKey();
            ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)entry.getValue();
            if (!requiredTests.containsKey(testName)) continue;
            TestSpecification testSpec = requiredTests.get(testName);
            boolean noPayloads = testSpec.getPayload() == null;
            HashSet bucketValues = Sets.newHashSet();
            ArrayList buckets = testDefinition.getBuckets();
            for (TestBucket bucket : buckets) {
                bucketValues.add(bucket.getValue());
                if (!noPayloads || bucket.getPayload() == null) continue;
                bucket.setPayload(null);
            }
            boolean replaceBuckets = false;
            Map<String, Integer> specBuckets = testSpec.getBuckets();
            for (Map.Entry<String, Integer> bucketSpec : specBuckets.entrySet()) {
                if (bucketValues.contains(bucketSpec.getValue())) continue;
                if (!replaceBuckets) {
                    buckets = Lists.newArrayList(buckets);
                    replaceBuckets = true;
                }
                buckets.add(new TestBucket(bucketSpec.getKey(), bucketSpec.getValue(), null, null));
            }
            if (!replaceBuckets) continue;
            testDefinition.setBuckets(buckets);
        }
    }

    @Nonnull
    private static ConsumableTestDefinition defaultFor(String testName, @Nonnull TestSpecification testSpecification) {
        String missingTestSoleBucketName = "inactive";
        String missingTestSoleBucketDescription = "inactive";
        Allocation allocation = new Allocation();
        allocation.setRanges((List<Range>)ImmutableList.of((Object)new Range(testSpecification.getFallbackValue(), 1.0)));
        return new ConsumableTestDefinition("default", null, TestType.RANDOM, testName, (List<TestBucket>)ImmutableList.of((Object)new TestBucket("inactive", testSpecification.getFallbackValue(), "inactive")), Collections.singletonList(allocation), Collections.emptyMap(), testName);
    }

    public static ProvidedContext convertContextToTestableMap(Map<String, String> providedContext) {
        return ProctorUtils.convertContextToTestableMap(providedContext, Collections.emptyMap());
    }

    public static ProvidedContext convertContextToTestableMap(Map<String, String> providedContext, Map<String, Object> ruleVerificationContext) {
        ExpressionFactoryImpl expressionFactory = new ExpressionFactoryImpl();
        HashMap<String, Object> primitiveVals = new HashMap<String, Object>();
        primitiveVals.put("int", 0);
        primitiveVals.put("integer", 0);
        primitiveVals.put("long", 0L);
        primitiveVals.put("bool", true);
        primitiveVals.put("boolean", true);
        primitiveVals.put("short", (short)0);
        primitiveVals.put("string", "");
        primitiveVals.put("double", 0.0);
        primitiveVals.put("char", "");
        primitiveVals.put("character", "");
        primitiveVals.put("byte", (byte)0);
        if (providedContext != null) {
            HashMap<String, Object> newProvidedContext = new HashMap<String, Object>();
            HashSet uninstantiatedIdentifiers = Sets.newHashSet();
            for (Map.Entry<String, String> entry : providedContext.entrySet()) {
                String identifier = entry.getKey();
                Object toAdd = null;
                if (ruleVerificationContext.containsKey(identifier)) {
                    toAdd = ruleVerificationContext.get(identifier);
                    LOGGER.debug((Object)String.format("Use instance for identifier {%s} provided by user %s", identifier, toAdd));
                } else {
                    String iobjName;
                    LOGGER.debug((Object)String.format("Identifier {%s} is not provided, instantiate it via default constructor", identifier));
                    String objName = iobjName = entry.getValue();
                    if (primitiveVals.get(objName.toLowerCase()) != null) {
                        toAdd = primitiveVals.get(objName.toLowerCase());
                    } else {
                        try {
                            Class<?> clazz = Class.forName(objName);
                            toAdd = clazz.isEnum() ? clazz.getEnumConstants()[0] : clazz.newInstance();
                        }
                        catch (IllegalAccessException e) {
                            uninstantiatedIdentifiers.add(identifier);
                            LOGGER.debug((Object)("Couldn't access default constructor of " + iobjName + " in providedContext. Rule verification will skip this identifier - " + identifier));
                        }
                        catch (InstantiationException e) {
                            uninstantiatedIdentifiers.add(identifier);
                            LOGGER.debug((Object)("Couldn't find default constructor for " + iobjName + " in providedContext. Rule verification will skip this identifier - " + identifier));
                        }
                        catch (ClassNotFoundException e) {
                            uninstantiatedIdentifiers.add(identifier);
                            LOGGER.error((Object)("Class not found for " + iobjName + " in providedContext"));
                        }
                    }
                }
                newProvidedContext.put(identifier, toAdd);
            }
            return new ProvidedContext(ProctorUtils.convertToValueExpressionMap((ExpressionFactory)expressionFactory, newProvidedContext), true, uninstantiatedIdentifiers);
        }
        return new ProvidedContext(ProvidedContext.EMPTY_CONTEXT, false);
    }

    public static void verifyInternallyConsistentDefinition(String testName, String matrixSource, @Nonnull ConsumableTestDefinition testDefinition) throws IncompatibleTestMatrixException {
        ProctorUtils.verifyInternallyConsistentDefinition(testName, matrixSource, testDefinition, RuleEvaluator.FUNCTION_MAPPER, new ProvidedContext(ProvidedContext.EMPTY_CONTEXT, false));
    }

    public static void verifyInternallyConsistentDefinition(String testName, String matrixSource, @Nonnull ConsumableTestDefinition testDefinition, FunctionMapper functionMapper, ProvidedContext providedContext) throws IncompatibleTestMatrixException {
        List<Allocation> allocations = testDefinition.getAllocations();
        ExpressionFactoryImpl expressionFactory = new ExpressionFactoryImpl();
        String testRule = testDefinition.getRule();
        Map<String, ValueExpression> testConstants = ProctorUtils.convertToValueExpressionMap((ExpressionFactory)expressionFactory, testDefinition.getConstants());
        MulticontextReadOnlyVariableMapper variableMapper = new MulticontextReadOnlyVariableMapper(testConstants, providedContext.getContext());
        RuleEvaluator ruleEvaluator = new RuleEvaluator((ExpressionFactory)expressionFactory, functionMapper, testDefinition.getConstants());
        ELContext elContext = ruleEvaluator.createELContext(variableMapper);
        try {
            RuleVerifyUtils.verifyRule(testRule, providedContext.shouldEvaluate(), (ExpressionFactory)expressionFactory, elContext, providedContext.getUninstantiatedIdentifiers());
        }
        catch (ELException e) {
            LOGGER.error((Object)e);
            throw new IncompatibleTestMatrixException("Unable to evaluate rule ${" + testRule + "} in " + testName);
        }
        if (allocations.isEmpty()) {
            throw new IncompatibleTestMatrixException("No allocations specified in test " + testName);
        }
        List<TestBucket> buckets = testDefinition.getBuckets();
        HashSet definedBuckets = Sets.newHashSet();
        for (TestBucket bucket : buckets) {
            definedBuckets.add(bucket.getValue());
        }
        for (int i = 0; i < allocations.size(); ++i) {
            Allocation allocation = allocations.get(i);
            List<Range> ranges = allocation.getRanges();
            double bucketTotal = 0.0;
            for (Range range : ranges) {
                bucketTotal += range.getLength();
                if (definedBuckets.contains(range.getBucketValue())) continue;
                throw new IncompatibleTestMatrixException("Allocation range in " + testName + " from " + matrixSource + " refers to unknown bucket value " + range.getBucketValue());
            }
            if (bucketTotal < 0.9999 || bucketTotal > 1.0001) {
                StringBuilder sb = new StringBuilder(testName + " range with rule " + allocation.getRule() + " does not add up to 1 : ").append(ranges.get(0).getLength());
                for (int r = 1; r < ranges.size(); ++r) {
                    sb.append(" + ").append(ranges.get(r).getLength());
                }
                sb.append(" = ").append(bucketTotal);
                throw new IncompatibleTestMatrixException(sb.toString());
            }
            String rule = allocation.getRule();
            boolean lastAllocation = i == allocations.size() - 1;
            String bareRule = ProctorUtils.removeElExpressionBraces(rule);
            if (!lastAllocation && ProctorUtils.isEmptyWhitespace(bareRule)) {
                throw new IncompatibleTestMatrixException("Allocation[" + i + "] for test " + testName + " from " + matrixSource + " has empty rule: " + allocation.getRule());
            }
            try {
                RuleVerifyUtils.verifyRule(rule, providedContext.shouldEvaluate(), (ExpressionFactory)expressionFactory, elContext, providedContext.getUninstantiatedIdentifiers());
                continue;
            }
            catch (ELException e) {
                LOGGER.error((Object)e);
                throw new IncompatibleTestMatrixException("Unable to evaluate rule ${" + rule + "} in allocations of " + testName);
            }
        }
        Payload nonEmptyPayload = null;
        ArrayList bucketsWithoutPayloads = Lists.newArrayList();
        for (TestBucket bucket : buckets) {
            Payload p = bucket.getPayload();
            if (p != null) {
                if (p.numFieldsDefined() != 1) {
                    throw new IncompatibleTestMatrixException("Test " + testName + " from " + matrixSource + " has a test bucket payload with multiple types: " + bucket);
                }
                if (nonEmptyPayload == null) {
                    nonEmptyPayload = p;
                    continue;
                }
                if (nonEmptyPayload.sameType(p)) continue;
                throw new IncompatibleTestMatrixException("Test " + testName + " from " + matrixSource + " has test bucket: " + bucket + " incompatible with type of payload: " + nonEmptyPayload);
            }
            bucketsWithoutPayloads.add(bucket);
        }
        if (nonEmptyPayload != null && bucketsWithoutPayloads.size() != 0) {
            throw new IncompatibleTestMatrixException("Test " + testName + " from " + matrixSource + " has some test buckets without payloads: " + bucketsWithoutPayloads);
        }
    }

    static boolean isEmptyWhitespace(@Nullable String s) {
        if (s == null) {
            return true;
        }
        return CharMatcher.WHITESPACE.matchesAllOf((CharSequence)s);
    }

    public static TestSpecification generateSpecification(@Nonnull TestDefinition testDefinition) {
        TestSpecification testSpecification = new TestSpecification();
        LinkedHashMap buckets = Maps.newLinkedHashMap();
        ImmutableList testDefinitionBuckets = Ordering.from((Comparator)new Comparator<TestBucket>(){

            @Override
            public int compare(TestBucket lhs, TestBucket rhs) {
                return Ints.compare((int)lhs.getValue(), (int)rhs.getValue());
            }
        }).immutableSortedCopy(testDefinition.getBuckets());
        int fallbackValue = -1;
        if (testDefinitionBuckets.size() > 0) {
            TestBucket firstBucket = (TestBucket)testDefinitionBuckets.get(0);
            fallbackValue = firstBucket.getValue();
            PayloadSpecification payloadSpecification = new PayloadSpecification();
            if (firstBucket.getPayload() != null && !firstBucket.getPayload().equals(Payload.EMPTY_PAYLOAD)) {
                PayloadType payloadType = PayloadType.payloadTypeForName(firstBucket.getPayload().fetchType());
                payloadSpecification.setType(payloadType.payloadTypeName);
                if (payloadType == PayloadType.MAP) {
                    HashMap<String, String> payloadSpecificationSchema = new HashMap<String, String>();
                    for (Map.Entry<String, Object> entry : firstBucket.getPayload().getMap().entrySet()) {
                        payloadSpecificationSchema.put(entry.getKey(), PayloadType.payloadTypeForValue((Object)entry.getValue()).payloadTypeName);
                    }
                    payloadSpecification.setSchema(payloadSpecificationSchema);
                }
                testSpecification.setPayload(payloadSpecification);
            }
            for (int i = 0; i < testDefinitionBuckets.size(); ++i) {
                TestBucket bucket = (TestBucket)testDefinitionBuckets.get(i);
                buckets.put(bucket.getName(), bucket.getValue());
            }
        }
        testSpecification.setBuckets(buckets);
        testSpecification.setDescription(testDefinition.getDescription());
        testSpecification.setFallbackValue(fallbackValue);
        return testSpecification;
    }

    @Nullable
    static String removeElExpressionBraces(@Nullable String rule) {
        int startchar;
        if (ProctorUtils.isEmptyWhitespace(rule)) {
            return null;
        }
        int endchar = rule.length() - 1;
        for (startchar = 0; startchar < rule.length() && CharMatcher.WHITESPACE.matches(rule.charAt(startchar)); ++startchar) {
        }
        while (endchar > startchar && CharMatcher.WHITESPACE.matches(rule.charAt(endchar))) {
            --endchar;
        }
        if (rule.regionMatches(startchar, "${", 0, 2) && rule.charAt(endchar) == '}') {
            startchar += 2;
            --endchar;
        }
        while (startchar < rule.length() && CharMatcher.WHITESPACE.matches(rule.charAt(startchar))) {
            ++startchar;
        }
        while (endchar > startchar && CharMatcher.WHITESPACE.matches(rule.charAt(endchar))) {
            --endchar;
        }
        if (endchar < startchar) {
            return null;
        }
        return rule.substring(startchar, endchar + 1);
    }

    @Nonnull
    private static RuleEvaluator makeRuleEvaluator(ExpressionFactory expressionFactory, FunctionMapper functionMapper) {
        Map<String, Object> testConstants = Collections.emptyMap();
        return new RuleEvaluator(expressionFactory, functionMapper, testConstants);
    }

    private static boolean evaluatePayloadMapValidator(@Nonnull RuleEvaluator ruleEvaluator, String rule, @Nonnull Payload payload) throws IncompatibleTestMatrixException {
        try {
            return ruleEvaluator.evaluateBooleanRule(rule, payload.getMap());
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)("Unable to evaluate rule ${" + rule + "} with payload " + payload), (Throwable)e);
            return true;
        }
    }

    private static boolean evaluatePayloadValidator(@Nonnull RuleEvaluator ruleEvaluator, String rule, @Nonnull Payload payload) throws IncompatibleTestMatrixException {
        Map<String, Object> values = Collections.singletonMap("value", payload.fetchAValue());
        try {
            return ruleEvaluator.evaluateBooleanRule(rule, values);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)("Unable to evaluate rule ${" + rule + "} with payload " + payload), (Throwable)e);
            return false;
        }
    }
}

