/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.indeed.proctor.common.AbstractProctorDiffReporter;
import com.indeed.proctor.common.IncompatibleTestMatrixException;
import com.indeed.proctor.common.MissingTestMatrixException;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.common.ProctorLoadReporter;
import com.indeed.proctor.common.ProctorLoadResult;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.ProvidedContext;
import com.indeed.proctor.common.TestSpecification;
import com.indeed.proctor.common.model.Audit;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.util.core.DataLoadingTimerTask;
import com.indeed.util.varexport.Export;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.el.FunctionMapper;
import org.apache.log4j.Logger;

public abstract class AbstractProctorLoader
extends DataLoadingTimerTask
implements Supplier<Proctor> {
    private static final Logger LOGGER = Logger.getLogger(AbstractProctorLoader.class);
    @Nullable
    protected final Map<String, TestSpecification> requiredTests;
    @Nullable
    private Proctor current = null;
    @Nullable
    private Audit lastAudit = null;
    @Nullable
    private String lastLoadErrorMessage = "load never attempted";
    @Nonnull
    private final FunctionMapper functionMapper;
    private final ProvidedContext providedContext;
    private final List<ProctorLoadReporter> reporters = new ArrayList<ProctorLoadReporter>();

    public AbstractProctorLoader(@Nonnull Class<?> cls, @Nonnull ProctorSpecification specification, @Nonnull FunctionMapper functionMapper) {
        super(cls.getSimpleName());
        this.requiredTests = specification.getTests();
        this.providedContext = this.createProvidedContext(specification);
        if (!this.providedContext.shouldEvaluate()) {
            LOGGER.debug((Object)"providedContext Objects missing necessary functions for validation, rules will not be tested.");
        }
        this.functionMapper = functionMapper;
    }

    protected Map<String, Object> getRuleVerificationContext() {
        return Collections.emptyMap();
    }

    protected ProvidedContext createProvidedContext(ProctorSpecification specification) {
        return ProctorUtils.convertContextToTestableMap(specification.getProvidedContext(), this.getRuleVerificationContext());
    }

    @Nullable
    abstract TestMatrixArtifact loadTestMatrix() throws IOException, MissingTestMatrixException;

    @Nonnull
    abstract String getSource();

    public boolean load() {
        Proctor newProctor;
        try {
            newProctor = this.doLoad();
        }
        catch (Throwable t) {
            this.reportFailed(t);
            this.lastLoadErrorMessage = t.getMessage();
            throw new RuntimeException("Unable to reload proctor from " + this.getSource(), t);
        }
        this.lastLoadErrorMessage = null;
        if (newProctor == null) {
            if (!this.dataLoadTimer.isLoadedDataSuccessfullyRecently()) {
                this.dataLoadTimer.loadComplete();
            }
            this.reportNoChange();
            return false;
        }
        this.reportReloaded(this.current, newProctor);
        this.current = newProctor;
        Audit lastAudit = (Audit)Preconditions.checkNotNull((Object)this.lastAudit, (Object)"Missing last audit");
        this.setDataVersion(lastAudit.getVersion() + " @ " + lastAudit.getUpdated() + " by " + lastAudit.getUpdatedBy());
        LOGGER.info((Object)("Successfully loaded new test matrix definition: " + lastAudit.getVersion() + " @ " + lastAudit.getUpdated() + " by " + lastAudit.getUpdatedBy()));
        return true;
    }

    @Nullable
    public Proctor doLoad() throws IOException, MissingTestMatrixException {
        TestMatrixArtifact testMatrix = this.loadTestMatrix();
        if (testMatrix == null) {
            throw new MissingTestMatrixException("Failed to load Test Matrix from " + this.getSource());
        }
        ProctorLoadResult loadResult = this.requiredTests == null ? ProctorUtils.verifyWithoutSpecification(testMatrix, this.getSource()) : ProctorUtils.verifyAndConsolidate(testMatrix, this.getSource(), this.requiredTests, this.functionMapper, this.providedContext);
        if (!loadResult.getTestErrorMap().isEmpty()) {
            for (Map.Entry<String, IncompatibleTestMatrixException> errorTest : loadResult.getTestErrorMap().entrySet()) {
                LOGGER.error((Object)String.format("Unable to load test matrix for %s", errorTest.getKey()), (Throwable)errorTest.getValue());
            }
        }
        Audit newAudit = testMatrix.getAudit();
        if (this.lastAudit != null) {
            Audit audit = (Audit)Preconditions.checkNotNull((Object)newAudit, (Object)"Missing audit");
            if (this.lastAudit.getVersion().equals(audit.getVersion())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Not reloading " + this.getSource() + " test matrix definition because audit is unchanged: " + this.lastAudit.getVersion() + " @ " + this.lastAudit.getUpdated() + " by " + this.lastAudit.getUpdatedBy()));
                }
                return null;
            }
        }
        Proctor proctor = Proctor.construct(testMatrix, loadResult, this.functionMapper);
        this.lastAudit = newAudit;
        return proctor;
    }

    @Nullable
    public Proctor get() {
        return this.current;
    }

    @Nullable
    @Export(name="last-audit")
    public Audit getLastAudit() {
        return this.lastAudit;
    }

    @Nullable
    @Export(name="last-error", doc="The last error message thrown by the loader. null indicates a successful load.")
    public String getLastLoadErrorMessage() {
        return this.lastLoadErrorMessage;
    }

    public boolean isLoadedDataSuccessfullyRecently() {
        return this.dataLoadTimer.isLoadedDataSuccessfullyRecently();
    }

    @Deprecated
    public void setDiffReporter(@Nonnull AbstractProctorDiffReporter diffReporter) {
        this.addLoadReporter(diffReporter);
    }

    public void addLoadReporter(@Nonnull ProctorLoadReporter diffReporter) {
        Preconditions.checkNotNull((Object)diffReporter, (Object)"ProctorLoadReporter can't be null");
        this.addLoadReporter((List<ProctorLoadReporter>)ImmutableList.of((Object)diffReporter));
    }

    public void addLoadReporter(@Nonnull List<ProctorLoadReporter> newReporters) {
        Preconditions.checkNotNull(newReporters, (Object)"new reporters shouldn't be empty");
        this.reporters.addAll(newReporters);
    }

    void reportFailed(Throwable t) {
        for (ProctorLoadReporter reporter : this.reporters) {
            reporter.reportFailed(t);
        }
    }

    void reportReloaded(Proctor oldProctor, Proctor newProctor) {
        for (ProctorLoadReporter reporter : this.reporters) {
            reporter.reportReloaded(oldProctor, newProctor);
        }
    }

    void reportNoChange() {
        for (ProctorLoadReporter reporter : this.reporters) {
            reporter.reportNoChange();
        }
    }
}

