/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Audit {
    public static final String EMPTY_VERSION = "";
    public static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("US/Central");
    private String version;
    private long updated;
    @Nullable
    private String updatedDate;
    @Nullable
    private String updatedBy;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getUpdated() {
        return this.updated;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
        if (updated > 0L) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
            formatter.setTimeZone(DEFAULT_TIMEZONE);
            this.updatedDate = formatter.format(new Date(updated));
        } else {
            this.updatedDate = EMPTY_VERSION;
        }
    }

    @Nullable
    public String getUpdatedDate() {
        return this.updatedDate;
    }

    @Nullable
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Nonnull
    public String toString() {
        return "Audit{version=" + this.version + ", updated=" + this.updated + ", updatedDate=" + this.updatedDate + ", updatedBy='" + this.updatedBy + '\'' + '}';
    }
}

