/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ProctorLoadResult {
    @Nonnull
    private final Map<String, String> testErrorMap;
    @Nonnull
    private final Set<String> missingTests;
    private final boolean verifiedRules;
    private static final ProctorLoadResult EMPTY = ProctorLoadResult.newBuilder().build();

    public ProctorLoadResult(@Nonnull Set<String> testsWithErrors, @Nonnull Set<String> missingTests) {
        this(testsWithErrors, missingTests, false);
    }

    public ProctorLoadResult(@Nonnull Set<String> testsWithErrors, @Nonnull Set<String> missingTests, boolean verifiedRules) {
        this(ProctorLoadResult.makeTestErrorMap(testsWithErrors), missingTests, verifiedRules);
    }

    public ProctorLoadResult(@Nonnull Map<String, String> testErrorMap, @Nonnull Set<String> missingTests, boolean verifiedRules) {
        this.testErrorMap = testErrorMap;
        this.missingTests = missingTests;
        this.verifiedRules = verifiedRules;
    }

    @Nonnull
    public Set<String> getTestsWithErrors() {
        return this.testErrorMap.keySet();
    }

    @Nonnull
    public Map<String, String> getTestErrorMap() {
        return this.testErrorMap;
    }

    @Nonnull
    public Set<String> getMissingTests() {
        return this.missingTests;
    }

    public boolean getVerifiedRules() {
        return this.verifiedRules;
    }

    private static Map<String, String> makeTestErrorMap(Set<String> testsWithErrors) {
        return Maps.asMap(testsWithErrors, (Function)new Function<String, String>(){

            public String apply(String testName) {
                return testName + " has an invalid specification";
            }
        });
    }

    public boolean hasInvalidTests() {
        return !this.testErrorMap.isEmpty() || !this.missingTests.isEmpty();
    }

    @Nonnull
    public static ProctorLoadResult emptyResult() {
        return EMPTY;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableMap.Builder<String, String> testsWithErrors = ImmutableMap.builder();
        private ImmutableSet.Builder<String> missingTests = ImmutableSet.builder();
        private boolean verifiedRules = false;

        private Builder() {
        }

        @Nonnull
        public Builder recordError(String testName, String message) {
            this.testsWithErrors.put((Object)testName, (Object)message);
            return this;
        }

        @Nonnull
        public Builder recordError(String testName) {
            this.testsWithErrors.put((Object)testName, (Object)(testName + " has an invalid specification"));
            return this;
        }

        @Nonnull
        public Builder recordMissing(String testName) {
            this.missingTests.add((Object)testName);
            return this;
        }

        @Nonnull
        public Builder recordAllMissing(Collection<String> testNames) {
            this.missingTests.addAll(testNames);
            return this;
        }

        public Builder recordVerifiedRules(boolean verifiedRulesInput) {
            this.verifiedRules = verifiedRulesInput;
            return this;
        }

        @Nonnull
        public ProctorLoadResult build() {
            return new ProctorLoadResult((Map<String, String>)this.testsWithErrors.build(), (Set<String>)this.missingTests.build(), this.verifiedRules);
        }
    }
}

