/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.indeed.proctor.common.IncompatibleTestMatrixException;
import com.indeed.proctor.common.PayloadSpecification;
import com.indeed.proctor.common.PayloadType;
import com.indeed.proctor.common.ProctorLoadResult;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.TestSpecification;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.Audit;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Payload;
import com.indeed.proctor.common.model.Range;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestDefinition;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.proctor.common.model.TestMatrixDefinition;
import com.indeed.proctor.common.model.TestMatrixVersion;
import com.indeed.proctor.common.model.TestType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class ProctorUtils {
    private static final ObjectMapper OBJECT_MAPPER = Serializers.lenient();
    private static final Logger LOGGER = Logger.getLogger(ProctorUtils.class);

    public static MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Impossible no MD5", e);
        }
    }

    @Nonnull
    public static Map<String, ValueExpression> convertToValueExpressionMap(@Nonnull ExpressionFactory expressionFactory, @Nonnull Map<String, Object> values) {
        HashMap<String, ValueExpression> context = new HashMap<String, ValueExpression>(values.size());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            ValueExpression ve = expressionFactory.createValueExpression(entry.getValue(), Object.class);
            context.put(entry.getKey(), ve);
        }
        return context;
    }

    public static String convertToArtifact(@Nonnull TestMatrixVersion testMatrix) throws IOException {
        StringWriter sw = new StringWriter();
        TestMatrixArtifact artifact = ProctorUtils.convertToConsumableArtifact(testMatrix);
        ProctorUtils.serializeArtifact(sw, artifact);
        return sw.toString();
    }

    public static void serializeArtifact(Writer writer, TestMatrixArtifact artifact) throws IOException {
        ProctorUtils.serializeObject(writer, artifact);
    }

    public static void serializeTestDefinition(Writer writer, TestDefinition definition) throws IOException {
        ProctorUtils.serializeObject(writer, definition);
    }

    private static <T> void serializeObject(Writer writer, T artifact) throws IOException {
        OBJECT_MAPPER.defaultPrettyPrintingWriter().writeValue(writer, artifact);
    }

    @Nonnull
    public static TestMatrixArtifact convertToConsumableArtifact(@Nonnull TestMatrixVersion testMatrix) {
        Audit audit = new Audit();
        Date published = (Date)Preconditions.checkNotNull((Object)testMatrix.getPublished(), (Object)"Missing publication date");
        audit.setUpdated(published.getTime());
        audit.setVersion(testMatrix.getVersion());
        audit.setUpdatedBy(testMatrix.getAuthor());
        TestMatrixArtifact artifact = new TestMatrixArtifact();
        artifact.setAudit(audit);
        TestMatrixDefinition testMatrixDefinition = (TestMatrixDefinition)Preconditions.checkNotNull((Object)testMatrix.getTestMatrixDefinition(), (Object)"Missing test matrix definition");
        Map<String, TestDefinition> testDefinitions = testMatrixDefinition.getTests();
        LinkedHashMap consumableTestDefinitions = Maps.newLinkedHashMap();
        for (Map.Entry<String, TestDefinition> entry : testDefinitions.entrySet()) {
            TestDefinition td = entry.getValue();
            ConsumableTestDefinition ctd = ProctorUtils.convertToConsumableTestDefinition(td);
            consumableTestDefinitions.put(entry.getKey(), ctd);
        }
        artifact.setTests(consumableTestDefinitions);
        return artifact;
    }

    @Nonnull
    public static ConsumableTestDefinition convertToConsumableTestDefinition(@Nonnull TestDefinition td) {
        String rule;
        String rawRule;
        Map<String, Object> specialConstants = td.getSpecialConstants();
        ArrayList ruleComponents = Lists.newArrayList();
        List countries = (List)specialConstants.get("__COUNTRIES");
        if (countries != null) {
            ruleComponents.add("proctor:contains(__COUNTRIES, country)");
        }
        if (!ProctorUtils.isEmptyWhitespace(rawRule = ProctorUtils.removeElExpressionBraces(td.getRule()))) {
            ruleComponents.add(rawRule);
        }
        if (ruleComponents.isEmpty()) {
            rule = null;
        } else {
            StringBuilder ruleBuilder = new StringBuilder("${");
            for (int i = 0; i < ruleComponents.size(); ++i) {
                if (i != 0) {
                    ruleBuilder.append(" && ");
                }
                ruleBuilder.append((String)ruleComponents.get(i));
            }
            ruleBuilder.append("}");
            rule = ruleBuilder.toString();
        }
        List<Allocation> allocations = td.getAllocations();
        for (Allocation alloc : allocations) {
            String rawAllocRule = ProctorUtils.removeElExpressionBraces(alloc.getRule());
            if (ProctorUtils.isEmptyWhitespace(rawAllocRule)) {
                alloc.setRule(null);
                continue;
            }
            if (rawAllocRule.startsWith("${") && rawAllocRule.endsWith("}")) continue;
            String newAllocRule = "${" + rawAllocRule + "}";
            alloc.setRule(newAllocRule);
        }
        LinkedHashMap constants = Maps.newLinkedHashMap();
        constants.putAll(td.getConstants());
        constants.putAll(specialConstants);
        return new ConsumableTestDefinition(td.getVersion(), rule, td.getTestType(), td.getSalt(), td.getBuckets(), allocations, constants, td.getDescription());
    }

    public static ProctorSpecification readSpecification(File inputFile) {
        ProctorSpecification spec;
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(inputFile));
            spec = ProctorUtils.readSpecification(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read test set from " + inputFile, e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Suppressing throwable thrown when closing " + inputFile), (Throwable)e);
                }
            }
        }
        return spec;
    }

    public static ProctorSpecification readSpecification(InputStream inputFile) {
        ProctorSpecification spec;
        try {
            spec = (ProctorSpecification)OBJECT_MAPPER.readValue(inputFile, ProctorSpecification.class);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Unable to read test set from " + inputFile + ": ", e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Unable to read test set from " + inputFile, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read test set from " + inputFile, e);
        }
        return spec;
    }

    public static ProctorLoadResult verifyAndConsolidate(@Nonnull TestMatrixArtifact testMatrix, String matrixSource, @Nonnull Map<String, TestSpecification> requiredTests, @Nonnull FunctionMapper functionMapper) {
        ProctorLoadResult result = ProctorUtils.verify(testMatrix, matrixSource, requiredTests, functionMapper);
        Map<String, ConsumableTestDefinition> definedTests = testMatrix.getTests();
        for (String invalidTest : result.getTestsWithErrors()) {
            definedTests.remove(invalidTest);
        }
        ProctorUtils.consolidate(testMatrix, requiredTests);
        return result;
    }

    public static ProctorLoadResult verify(@Nonnull TestMatrixArtifact testMatrix, String matrixSource, @Nonnull Map<String, TestSpecification> requiredTests) {
        return ProctorUtils.verify(testMatrix, matrixSource, requiredTests, RuleEvaluator.FUNCTION_MAPPER);
    }

    public static ProctorLoadResult verify(@Nonnull TestMatrixArtifact testMatrix, String matrixSource, @Nonnull Map<String, TestSpecification> requiredTests, @Nonnull FunctionMapper functionMapper) {
        ProctorLoadResult.Builder resultBuilder = ProctorLoadResult.newBuilder();
        HashMap allTestsKnownBuckets = Maps.newHashMapWithExpectedSize((int)requiredTests.size());
        for (Map.Entry<String, TestSpecification> entry : requiredTests.entrySet()) {
            HashMap bucketValueToName = Maps.newHashMap();
            for (Map.Entry<String, Integer> bucket : entry.getValue().getBuckets().entrySet()) {
                bucketValueToName.put(bucket.getValue(), bucket.getKey());
            }
            allTestsKnownBuckets.put(entry.getKey(), bucketValueToName);
        }
        Map<String, ConsumableTestDefinition> definedTests = testMatrix.getTests();
        Sets.SetView missingTests = Sets.difference(requiredTests.keySet(), definedTests.keySet());
        resultBuilder.recordAllMissing((Collection<String>)missingTests);
        for (Map.Entry<String, ConsumableTestDefinition> entry : definedTests.entrySet()) {
            String testName = entry.getKey();
            Map knownBuckets = (Map)allTestsKnownBuckets.remove(testName);
            if (knownBuckets == null) continue;
            ConsumableTestDefinition testDefinition = entry.getValue();
            try {
                ProctorUtils.verifyTest(testName, testDefinition, requiredTests.get(testName), knownBuckets, matrixSource, functionMapper);
            }
            catch (IncompatibleTestMatrixException e) {
                LOGGER.error((Object)String.format("Unable to load test matrix for %s", testName), (Throwable)e);
                resultBuilder.recordError(testName);
            }
        }
        resultBuilder.recordAllMissing(allTestsKnownBuckets.keySet());
        ProctorLoadResult loadResult = resultBuilder.build();
        return loadResult;
    }

    private static void verifyTest(@Nonnull String testName, @Nonnull ConsumableTestDefinition testDefinition, @Nonnull TestSpecification testSpecification, @Nonnull Map<Integer, String> knownBuckets, @Nonnull String matrixSource, @Nonnull FunctionMapper functionMapper) throws IncompatibleTestMatrixException {
        List<Allocation> allocations = testDefinition.getAllocations();
        TestType declaredType = testDefinition.getTestType();
        if (!TestType.all().contains(declaredType)) {
            throw new IncompatibleTestMatrixException(String.format("Test '%s' is included in the application specification but refers to unknown id type '%s'.", testName, declaredType));
        }
        ProctorUtils.verifyInternallyConsistentDefinition(testName, matrixSource, testDefinition);
        HashSet unknownBuckets = Sets.newHashSet();
        for (Allocation allocation : allocations) {
            List<Range> ranges = allocation.getRanges();
            for (Range range : ranges) {
                if (knownBuckets.containsKey(range.getBucketValue()) || !(range.getLength() > 0.0)) continue;
                unknownBuckets.add(range.getBucketValue());
            }
        }
        if (unknownBuckets.size() > 0) {
            throw new IncompatibleTestMatrixException("Allocation range in " + testName + " from " + matrixSource + " refers to unknown bucket value(s) " + unknownBuckets + " with length > 0");
        }
        RuleEvaluator ruleEvaluator = ProctorUtils.makeRuleEvaluator(RuleEvaluator.EXPRESSION_FACTORY, functionMapper);
        PayloadSpecification payloadSpec = testSpecification.getPayload();
        if (payloadSpec != null) {
            String specifiedPayloadTypeName = (String)Preconditions.checkNotNull((Object)payloadSpec.getType(), (Object)"Missing payload spec type");
            PayloadType specifiedPayloadType = PayloadType.payloadTypeForName(specifiedPayloadTypeName);
            if (specifiedPayloadType == null) {
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " test specification payload type unknown: " + specifiedPayloadTypeName);
            }
            String payloadValidatorRule = payloadSpec.getValidator();
            List<TestBucket> buckets = testDefinition.getBuckets();
            for (TestBucket bucket : buckets) {
                boolean payloadIsValid;
                Payload payload = bucket.getPayload();
                if (payload == null) continue;
                if (!specifiedPayloadType.payloadHasThisType(payload)) {
                    throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " expected payload of type " + specifiedPayloadType.payloadTypeName + " but matrix has a test bucket payload with wrong type: " + bucket);
                }
                if (payloadValidatorRule == null || (payloadIsValid = ProctorUtils.evaluatePayloadValidator(ruleEvaluator, payloadValidatorRule, payload))) continue;
                throw new IncompatibleTestMatrixException("For test " + testName + " from " + matrixSource + " payload validation rule " + payloadValidatorRule + " failed for test bucket: " + bucket);
            }
        }
    }

    private static void consolidate(@Nonnull TestMatrixArtifact testMatrix, @Nonnull Map<String, TestSpecification> requiredTests) {
        Map<String, ConsumableTestDefinition> definedTests = testMatrix.getTests();
        ImmutableSet toRemove = ImmutableSet.copyOf((Collection)Sets.difference(definedTests.keySet(), requiredTests.keySet()));
        for (String testInMatrixNotRequired : toRemove) {
            definedTests.remove(testInMatrixNotRequired);
        }
        ImmutableSet missing = ImmutableSet.copyOf((Collection)Sets.difference(requiredTests.keySet(), definedTests.keySet()));
        for (String string : missing) {
            definedTests.put(string, ProctorUtils.defaultFor(string, requiredTests.get(string)));
        }
        for (Map.Entry entry : definedTests.entrySet()) {
            String testName = (String)entry.getKey();
            ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)entry.getValue();
            TestSpecification testSpec = requiredTests.get(testName);
            if (testSpec.getPayload() != null) continue;
            List<TestBucket> buckets = testDefinition.getBuckets();
            for (TestBucket bucket : buckets) {
                if (bucket.getPayload() == null) continue;
                bucket.setPayload(null);
            }
        }
    }

    @Nonnull
    private static ConsumableTestDefinition defaultFor(String testName, @Nonnull TestSpecification testSpecification) {
        String missingTestSoleBucketName = "inactive";
        String missingTestSoleBucketDescription = "inactive";
        Allocation allocation = new Allocation();
        allocation.setRanges((List<Range>)ImmutableList.of((Object)new Range(testSpecification.getFallbackValue(), 1.0)));
        return new ConsumableTestDefinition(testSpecification.getFallbackValue(), null, TestType.RANDOM, testName, (List<TestBucket>)ImmutableList.of((Object)new TestBucket("inactive", testSpecification.getFallbackValue(), "inactive")), Collections.singletonList(allocation), Collections.<String, Object>emptyMap(), testName);
    }

    public static void verifyInternallyConsistentDefinition(String testName, String matrixSource, @Nonnull ConsumableTestDefinition testDefinition) throws IncompatibleTestMatrixException {
        List<Allocation> allocations = testDefinition.getAllocations();
        if (allocations.isEmpty()) {
            throw new IncompatibleTestMatrixException("No allocations specified in test " + testName);
        }
        List<TestBucket> buckets = testDefinition.getBuckets();
        HashSet definedBuckets = Sets.newHashSet();
        for (TestBucket bucket : buckets) {
            definedBuckets.add(bucket.getValue());
        }
        for (int i = 0; i < allocations.size(); ++i) {
            Allocation allocation = allocations.get(i);
            List<Range> ranges = allocation.getRanges();
            double bucketTotal = 0.0;
            for (Range range : ranges) {
                bucketTotal += range.getLength();
                if (definedBuckets.contains(range.getBucketValue())) continue;
                throw new IncompatibleTestMatrixException("Allocation range in " + testName + " from " + matrixSource + " refers to unknown bucket value " + range.getBucketValue());
            }
            if (bucketTotal < 0.9999 || bucketTotal > 1.0001) {
                StringBuilder sb = new StringBuilder(testName + " range with rule " + allocation.getRule() + " does not add up to 1 : ").append(ranges.get(0).getLength());
                for (int r = 1; r < ranges.size(); ++r) {
                    sb.append(" + ").append(ranges.get(r).getLength());
                }
                sb.append(" = ").append(bucketTotal);
                throw new IncompatibleTestMatrixException(sb.toString());
            }
            boolean lastAllocation = i == allocations.size() - 1;
            String bareRule = ProctorUtils.removeElExpressionBraces(allocation.getRule());
            if (lastAllocation) {
                if (ProctorUtils.isEmptyWhitespace(bareRule)) continue;
                throw new IncompatibleTestMatrixException("Allocation[" + i + "] for test " + testName + " from " + matrixSource + " has non-empty rule: " + allocation.getRule());
            }
            if (!ProctorUtils.isEmptyWhitespace(bareRule)) continue;
            throw new IncompatibleTestMatrixException("Allocation[" + i + "] for test " + testName + " from " + matrixSource + " has empty rule: " + allocation.getRule());
        }
        Payload nonEmptyPayload = null;
        ArrayList bucketsWithoutPayloads = Lists.newArrayList();
        for (TestBucket bucket : buckets) {
            Payload p = bucket.getPayload();
            if (p != null) {
                if (p.numFieldsDefined() != 1) {
                    throw new IncompatibleTestMatrixException("Test " + testName + " from " + matrixSource + " has a test bucket payload with multiple types: " + bucket);
                }
                if (nonEmptyPayload == null) {
                    nonEmptyPayload = p;
                    continue;
                }
                if (nonEmptyPayload.sameType(p)) continue;
                throw new IncompatibleTestMatrixException("Test " + testName + " from " + matrixSource + " has test bucket: " + bucket + " incompatible with type of payload: " + nonEmptyPayload);
            }
            bucketsWithoutPayloads.add(bucket);
        }
        if (nonEmptyPayload != null && bucketsWithoutPayloads.size() != 0) {
            throw new IncompatibleTestMatrixException("Test " + testName + " from " + matrixSource + " has some test buckets without payloads: " + bucketsWithoutPayloads);
        }
    }

    static boolean isEmptyWhitespace(@Nullable String s) {
        if (s == null) {
            return true;
        }
        return CharMatcher.WHITESPACE.matchesAllOf((CharSequence)s);
    }

    @Nullable
    static String removeElExpressionBraces(@Nullable String rule) {
        int startchar;
        if (ProctorUtils.isEmptyWhitespace(rule)) {
            return null;
        }
        int endchar = rule.length() - 1;
        for (startchar = 0; startchar < rule.length() && CharMatcher.WHITESPACE.matches(rule.charAt(startchar)); ++startchar) {
        }
        while (endchar > startchar && CharMatcher.WHITESPACE.matches(rule.charAt(endchar))) {
            --endchar;
        }
        if (rule.regionMatches(startchar, "${", 0, 2) && rule.charAt(endchar) == '}') {
            startchar += 2;
            --endchar;
        }
        while (startchar < rule.length() && CharMatcher.WHITESPACE.matches(rule.charAt(startchar))) {
            ++startchar;
        }
        while (endchar > startchar && CharMatcher.WHITESPACE.matches(rule.charAt(endchar))) {
            --endchar;
        }
        if (endchar < startchar) {
            return null;
        }
        return rule.substring(startchar, endchar + 1);
    }

    @Nonnull
    private static RuleEvaluator makeRuleEvaluator(ExpressionFactory expressionFactory, FunctionMapper functionMapper) {
        Map<String, Object> testConstants = Collections.emptyMap();
        return new RuleEvaluator(expressionFactory, functionMapper, testConstants);
    }

    private static boolean evaluatePayloadValidator(@Nonnull RuleEvaluator ruleEvaluator, String rule, @Nonnull Payload payload) throws IncompatibleTestMatrixException {
        Map<String, Object> values = Collections.singletonMap("value", payload.fetchAValue());
        try {
            return ruleEvaluator.evaluateBooleanRule(rule, values);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)("Unable to evaluate rule ${" + rule + "} with payload " + payload), (Throwable)e);
            return false;
        }
    }
}

