/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.annotations.VisibleForTesting;
import com.indeed.proctor.common.TestChooser;
import com.indeed.proctor.common.TestRangeSelector;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Range;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.shaded.javax.el7.ExpressionFactory;
import com.indeed.shaded.javax.el7.FunctionMapper;
import com.indeed.shaded.javax.el7.ValueExpression;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@VisibleForTesting
class RandomTestChooser
implements TestChooser<Void> {
    @Nonnull
    private final Random random;
    @Nonnull
    private final TestRangeSelector testRangeSelector;
    @Nonnull
    private final List<Allocation> allocations;

    public RandomTestChooser(ExpressionFactory expressionFactory, FunctionMapper functionMapper, String testName, @Nonnull ConsumableTestDefinition testDefinition) {
        this(System.nanoTime(), expressionFactory, functionMapper, testName, testDefinition);
    }

    public RandomTestChooser(long seed, ExpressionFactory expressionFactory, FunctionMapper functionMapper, String testName, @Nonnull ConsumableTestDefinition testDefinition) {
        this.testRangeSelector = new TestRangeSelector(expressionFactory, functionMapper, testName, testDefinition);
        this.allocations = testDefinition.getAllocations();
        this.random = new Random(seed);
    }

    @Nonnull
    private Map<String, String> getDescriptorParameters() {
        return Collections.singletonMap("type", this.testRangeSelector.getTestDefinition().getTestType().name());
    }

    public String toString() {
        Map<String, String> parameters = this.getDescriptorParameters();
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        this.testRangeSelector.printTestBuckets(writer, parameters);
        return ((Object)sw).toString();
    }

    @Override
    public void printTestBuckets(@Nonnull PrintWriter writer) {
        Map<String, String> parameters = this.getDescriptorParameters();
        this.testRangeSelector.printTestBuckets(writer, parameters);
    }

    @Override
    @Nullable
    public TestBucket getTestBucket(int value) {
        return this.testRangeSelector.getTestBucket(value);
    }

    @Override
    @Nonnull
    public String[] getRules() {
        return this.testRangeSelector.getRules();
    }

    @Override
    @Nonnull
    public ConsumableTestDefinition getTestDefinition() {
        return this.testRangeSelector.getTestDefinition();
    }

    @Override
    @Nonnull
    public String getTestName() {
        return this.testRangeSelector.getTestName();
    }

    @Override
    @Nonnull
    public TestChooser.Result chooseInternal(@Nullable Void identifier, @Nonnull Map<String, ValueExpression> localContext, @Nonnull Map<String, TestBucket> testGroups) {
        int matchingRuleIndex = this.testRangeSelector.findMatchingRuleWithValueExpr(localContext, testGroups);
        if (matchingRuleIndex < 0) {
            return TestChooser.Result.EMPTY;
        }
        return this.allocateRandomGroup(matchingRuleIndex);
    }

    TestChooser.Result allocateRandomGroup(int matchingRuleIndex) {
        TestBucket[] matchingBucketRange = this.testRangeSelector.getBucketRange(matchingRuleIndex);
        Allocation allocation = this.allocations.get(matchingRuleIndex);
        List<Range> ranges = allocation.getRanges();
        double nextDouble = this.random.nextDouble();
        double current = 0.0;
        for (Range range : ranges) {
            double max = current + range.getLength();
            if (nextDouble < max) {
                int matchingBucketValue = range.getBucketValue();
                return new TestChooser.Result(RandomTestChooser.getBucketForValue(matchingBucketValue, matchingBucketRange), allocation);
            }
            current = max;
        }
        return new TestChooser.Result(RandomTestChooser.getBucketForValue(ranges.get(ranges.size() - 1).getBucketValue(), matchingBucketRange), allocation);
    }

    static TestBucket getBucketForValue(int matchingBucketValue, @Nonnull TestBucket[] matchingBucketRange) {
        for (TestBucket bucket : matchingBucketRange) {
            if (matchingBucketValue != bucket.getValue()) continue;
            return bucket;
        }
        throw new IllegalStateException("Unable to find a bucket with value " + matchingBucketValue);
    }
}

