/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.shaded.javax.el7;

import com.indeed.shaded.javax.el7.ELContext;
import com.indeed.shaded.javax.el7.ELException;
import com.indeed.shaded.javax.el7.ELResolver;
import com.indeed.shaded.javax.el7.PropertyNotFoundException;
import com.indeed.shaded.javax.el7.PropertyNotWritableException;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapELResolver
extends ELResolver {
    private static final Class<?> UNMODIFIABLE = Collections.unmodifiableMap(new HashMap()).getClass();
    private final boolean readOnly;

    public MapELResolver() {
        this.readOnly = false;
    }

    public MapELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            context.setPropertyResolved(true);
            return ((Map)base).get(property);
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            context.setPropertyResolved(true);
            Object obj = ((Map)base).get(property);
            return obj != null ? obj.getClass() : null;
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            context.setPropertyResolved(true);
            if (this.readOnly) {
                throw new PropertyNotWritableException(MapELResolver.message(context, "resolverNotWriteable", new Object[]{base.getClass().getName()}));
            }
            try {
                Map map = (Map)base;
                map.put(property, value);
            }
            catch (UnsupportedOperationException e) {
                throw new PropertyNotWritableException(e);
            }
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            context.setPropertyResolved(true);
            return this.readOnly || UNMODIFIABLE.equals(base.getClass());
        }
        return this.readOnly;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base instanceof Map) {
            Iterator itr = ((Map)base).keySet().iterator();
            ArrayList<FeatureDescriptor> feats = new ArrayList<FeatureDescriptor>();
            while (itr.hasNext()) {
                Object key = itr.next();
                FeatureDescriptor desc = new FeatureDescriptor();
                desc.setDisplayName(key.toString());
                desc.setExpert(false);
                desc.setHidden(false);
                desc.setName(key.toString());
                desc.setPreferred(true);
                desc.setValue("resolvableAtDesignTime", Boolean.FALSE);
                desc.setValue("type", key.getClass());
                feats.add(desc);
            }
            return feats.iterator();
        }
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof Map) {
            return Object.class;
        }
        return null;
    }
}

