/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.gen;

import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.consumer.gen.CodeGenException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;

public abstract class FreeMarkerCodeGenerator {
    abstract Map<String, Object> populateRootMap(ProctorSpecification var1, Map<String, Object> var2, String var3, String var4);

    public static String toJavaIdentifier(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toLowerCase(s.charAt(0)));
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toEnumName(String s) {
        StringBuilder sb = new StringBuilder();
        boolean lastWasUpper = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c)) {
                if (Character.isLowerCase(c)) {
                    sb.append(Character.toUpperCase(c));
                    lastWasUpper = false;
                    continue;
                }
                if (!lastWasUpper) {
                    sb.append('_');
                }
                sb.append(c);
                lastWasUpper = true;
                continue;
            }
            if (c == '-') {
                sb.append('_');
            } else {
                sb.append(c);
            }
            lastWasUpper = false;
        }
        return sb.toString();
    }

    public static String uppercaseFirstChar(String name) {
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        String javaClassName = sb.toString();
        return javaClassName;
    }

    public static String packageToPath(String packageName) {
        return packageName.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
    }

    protected Configuration getFreemarkerConfiguration(String templatePath) {
        Configuration config = new Configuration();
        config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        config.setClassForTemplateLoading(this.getClass(), templatePath);
        return config;
    }

    protected void generate(ProctorSpecification specification, String target, Map<String, Object> baseContext, String packageName, String className, String templatePath, String templateName, String fileExtension) throws CodeGenException {
        Configuration config = this.getFreemarkerConfiguration(templatePath);
        Template template = FreeMarkerCodeGenerator.loadTemplate(templateName, templatePath, config);
        File fullPath = new File(target + File.separator + FreeMarkerCodeGenerator.packageToPath(packageName) + File.separator + className + fileExtension);
        try {
            fullPath.getParentFile().mkdirs();
            PrintWriter out = new PrintWriter(fullPath);
            Map<String, Object> rootMap = this.populateRootMap(specification, baseContext, packageName, className);
            SimpleHash model = new SimpleHash(rootMap);
            template.process((Object)model, (Writer)out);
            out.close();
        }
        catch (TemplateException e) {
            throw new RuntimeException("Unable to run template " + templateName + " to: " + fullPath, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to target file: " + fullPath, e);
        }
    }

    public static Template loadTemplate(String templateName, String templatePath, Configuration config) throws CodeGenException {
        try {
            return config.getTemplate(templateName);
        }
        catch (IOException e) {
            throw new CodeGenException("Unable to load template " + templateName + " from " + templatePath, e);
        }
    }
}

