/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.gen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.indeed.proctor.common.PayloadType;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.TestSpecification;
import com.indeed.proctor.common.dynamic.DynamicFilters;
import com.indeed.proctor.common.model.NameObfuscator;
import com.indeed.proctor.consumer.gen.CodeGenException;
import com.indeed.proctor.consumer.gen.FreeMarkerCodeGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class TestGroupsGenerator
extends FreeMarkerCodeGenerator {
    private static final ObjectMapper OBJECT_MAPPER = Serializers.lenient();
    private static final NameObfuscator TEST_NAME_OBFUSCATOR = new NameObfuscator();
    public static final String PROVIDED_CONTEXT_FILENAME = "providedcontext.json";
    public static final String DYNAMIC_FILTERS_FILENAME = "dynamicfilters.json";

    public static ProctorSpecification makeTotalSpecification(File inputDir, String targetDir) throws CodeGenException {
        return TestGroupsGenerator.makeTotalSpecification(inputDir, targetDir, inputDir.getPath().substring(inputDir.getPath().lastIndexOf(File.separator) + 1) + "Groups.json");
    }

    public static ProctorSpecification makeTotalSpecification(File inputDir, String targetDir, String outputFileName) throws CodeGenException {
        File[] dirFiles = inputDir.listFiles();
        return TestGroupsGenerator.makeTotalSpecification(Arrays.asList(dirFiles), targetDir, outputFileName);
    }

    public static ProctorSpecification makeTotalSpecification(List<File> inputFiles, String targetDir, String outputFileName) throws CodeGenException {
        ArrayList<File> providedContextFiles = new ArrayList<File>();
        ArrayList<File> dynamicFiltersFiles = new ArrayList<File>();
        for (File file : inputFiles) {
            if (PROVIDED_CONTEXT_FILENAME.equals(file.getName())) {
                providedContextFiles.add(file);
                continue;
            }
            if (!DYNAMIC_FILTERS_FILENAME.equals(file.getName())) continue;
            dynamicFiltersFiles.add(file);
        }
        if (providedContextFiles.size() != 1) {
            throw new CodeGenException("Incorrect amount of providedcontext.json in specified input folder. expected 1 but " + providedContextFiles.size() + ": " + providedContextFiles);
        }
        if (dynamicFiltersFiles.size() > 1) {
            throw new CodeGenException("Incorrect amount of dynamicfilters.json in specified input folder. expected 0 or 1 but " + dynamicFiltersFiles.size() + ": " + dynamicFiltersFiles);
        }
        LinkedHashMap<String, TestSpecification> testSpec = new LinkedHashMap<String, TestSpecification>();
        Map providedContext = null;
        DynamicFilters dynamicFilters = null;
        for (File file : inputFiles) {
            TestSpecification spec;
            String fileName = file.getName();
            if (fileName.equals(PROVIDED_CONTEXT_FILENAME)) {
                try {
                    providedContext = (Map)OBJECT_MAPPER.readValue(file, Map.class);
                    continue;
                }
                catch (IOException e) {
                    throw new CodeGenException("Could not read json correctly " + file.getAbsolutePath() + " for provided context", e);
                }
            }
            if (fileName.equals(DYNAMIC_FILTERS_FILENAME)) {
                try {
                    dynamicFilters = (DynamicFilters)OBJECT_MAPPER.readValue(file, DynamicFilters.class);
                    continue;
                }
                catch (IOException e) {
                    throw new CodeGenException("Could not read json correctly " + file.getAbsolutePath() + " for dynamic filters", e);
                }
            }
            if (!fileName.endsWith(".json")) continue;
            try {
                spec = (TestSpecification)OBJECT_MAPPER.readValue(file, TestSpecification.class);
            }
            catch (IOException e) {
                throw new CodeGenException("Could not read json correctly " + file.getAbsolutePath() + " for a test specification", e);
            }
            String specName = fileName.substring(0, fileName.indexOf(".json"));
            if (testSpec.containsKey(specName)) {
                throw new CodeGenException("Multiple " + fileName + " found, each test should only have 1 spec file");
            }
            testSpec.put(specName, spec);
        }
        ProctorSpecification proctorSpecification = new ProctorSpecification((Map)ObjectUtils.defaultIfNull(providedContext, new LinkedHashMap()), testSpec, (DynamicFilters)ObjectUtils.defaultIfNull(dynamicFilters, (Object)new DynamicFilters()));
        TestGroupsGenerator.validateProctorSpecification(proctorSpecification);
        File output = new File(targetDir, outputFileName);
        try {
            OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue(output, (Object)proctorSpecification);
        }
        catch (IOException e) {
            throw new CodeGenException("Could not write to temp file " + output.getAbsolutePath(), e);
        }
        return proctorSpecification;
    }

    private static void validateProctorSpecification(ProctorSpecification spec) throws CodeGenException {
        for (Map.Entry entry : spec.getTests().entrySet()) {
            String testName = (String)entry.getKey();
            TestSpecification testSpecification = (TestSpecification)entry.getValue();
            TestGroupsGenerator.validateTestSpecification(testName, testSpecification);
        }
    }

    @VisibleForTesting
    static void validateTestSpecification(String testName, TestSpecification testSpec) throws CodeGenException {
        HashSet<Integer> bucketValueSet = new HashSet<Integer>();
        for (Integer bucketValue : testSpec.getBuckets().values()) {
            if (bucketValue == null) {
                throw new CodeGenException("specification of " + testName + " has null bucket value");
            }
            if (bucketValueSet.add(bucketValue)) continue;
            throw new CodeGenException("specification of " + testName + " has duplicated bucket value " + bucketValue);
        }
    }

    @Override
    @VisibleForTesting
    Map<String, Object> populateRootMap(ProctorSpecification spec, Map<String, Object> baseContext, String packageName, String className) {
        HashMap<String, Object> rootMap = new HashMap<String, Object>(baseContext);
        Map tests = spec.getTests();
        ArrayList testDefs = Lists.newArrayListWithCapacity((int)tests.size());
        HashMap<String, HashMap<String, Object>> testDefsMap = new HashMap<String, HashMap<String, Object>>(tests.size());
        HashSet<String> forcePayloadTests = new HashSet<String>();
        TreeSet sortedTestNames = new TreeSet(tests.keySet());
        for (String testName : sortedTestNames) {
            LinkedHashSet buckets = Sets.newLinkedHashSet();
            TestSpecification testSpecification = (TestSpecification)tests.get(testName);
            Object[] sortedBuckets = testSpecification.getBuckets().entrySet().toArray(new Map.Entry[testSpecification.getBuckets().size()]);
            if (testSpecification.getPayload() != null && testSpecification.getPayload().getAllowForce()) {
                forcePayloadTests.add(testName);
            }
            Arrays.sort(sortedBuckets, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> e0, Map.Entry<String, Integer> e1) {
                    if (e0.getValue() < e1.getValue()) {
                        return -1;
                    }
                    return e0.getValue() == e1.getValue() ? 0 : 1;
                }
            });
            boolean foundFallbackValue = false;
            for (Map.Entry entry : sortedBuckets) {
                String bucketName = (String)entry.getKey();
                String enumName = TestGroupsGenerator.toEnumName(bucketName);
                HashMap bucketDef = new HashMap();
                String normalizedBucketName = TestGroupsGenerator.toJavaIdentifier(bucketName);
                bucketDef.put("value", entry.getValue());
                bucketDef.put("name", bucketName);
                bucketDef.put("normalizedName", normalizedBucketName);
                bucketDef.put("enumName", enumName);
                bucketDef.put("javaClassName", TestGroupsGenerator.uppercaseFirstChar(normalizedBucketName));
                buckets.add(bucketDef);
                foundFallbackValue = foundFallbackValue || ((Integer)entry.getValue()).intValue() == testSpecification.getFallbackValue();
            }
            if (!buckets.isEmpty() && !foundFallbackValue) {
                throw new IllegalArgumentException("Specified fallback value " + testSpecification.getFallbackValue() + " for test " + testName + " is not in the list of standard values: " + Arrays.toString(sortedBuckets));
            }
            String name = TestGroupsGenerator.toJavaIdentifier(testName);
            String enumName = TestGroupsGenerator.toEnumName(name);
            HashMap<String, Object> testDef = new HashMap<String, Object>();
            testDef.put("name", testName);
            testDef.put("normalizedName", name);
            testDef.put("enumName", enumName);
            testDef.put("javaClassName", TestGroupsGenerator.uppercaseFirstChar(name));
            testDef.put("buckets", buckets);
            testDef.put("defaultValue", testSpecification.getFallbackValue());
            ArrayList arrayList = new ArrayList();
            if (testSpecification.getPayload() != null) {
                String specifiedPayloadTypeName = testSpecification.getPayload().getType();
                PayloadType specifiedPayloadType = PayloadType.payloadTypeForName((String)specifiedPayloadTypeName);
                if (specifiedPayloadType == PayloadType.MAP) {
                    testDef.put("isMap", "true");
                    for (Map.Entry entry : testSpecification.getPayload().getSchema().entrySet()) {
                        HashMap<String, String> nestedPayloadsMap = new HashMap<String, String>();
                        nestedPayloadsMap.put("key", (String)entry.getKey());
                        PayloadType payloadTypeForValue = PayloadType.payloadTypeForName((String)((String)entry.getValue()));
                        if (payloadTypeForValue != PayloadType.MAP) {
                            nestedPayloadsMap.put("value", payloadTypeForValue.javaClassName);
                            nestedPayloadsMap.put("valueWithoutArray", payloadTypeForValue.javaClassName.substring(0, payloadTypeForValue.javaClassName.length() - 2));
                            if (PayloadType.STRING_ARRAY == payloadTypeForValue) {
                                nestedPayloadsMap.put("notANumber", "true");
                            }
                            nestedPayloadsMap.put("payloadTypeName", payloadTypeForValue.payloadTypeName);
                            arrayList.add(nestedPayloadsMap);
                            continue;
                        }
                        throw new IllegalArgumentException("Nested Map Payloads are not allowed");
                    }
                }
                if (specifiedPayloadType == PayloadType.JSON) {
                    testDef.put("isJson", "true");
                }
                this.addPayloadToTestDef(testDef, specifiedPayloadType);
            }
            if (testSpecification.getDescription() != null) {
                testDef.put("description", StringEscapeUtils.escapeJava((String)testSpecification.getDescription()));
            }
            testDef.put("nestedPayloadsList", arrayList);
            testDefs.add(testDef);
            String hashedProctorName = TEST_NAME_OBFUSCATOR.obfuscateTestName(testName);
            testDefsMap.put(hashedProctorName, testDef);
        }
        rootMap.put("contextArguments", spec.getProvidedContext());
        rootMap.put("mainClassName", className);
        rootMap.put("packageName", packageName);
        rootMap.put("testEnumName", "Test");
        rootMap.put("testDefs", testDefs);
        rootMap.put("testDefsMap", testDefsMap);
        rootMap.put("forcePayloadTests", forcePayloadTests);
        return rootMap;
    }

    abstract void addPayloadToTestDef(Map<String, Object> var1, PayloadType var2);
}

