/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.shaded.org.apache.el7.lang;

import com.indeed.shaded.javax.el7.ELContext;
import com.indeed.shaded.javax.el7.ELException;
import com.indeed.shaded.javax.el7.FunctionMapper;
import com.indeed.shaded.javax.el7.MethodExpression;
import com.indeed.shaded.javax.el7.ValueExpression;
import com.indeed.shaded.javax.el7.VariableMapper;
import com.indeed.shaded.org.apache.el7.MethodExpressionImpl;
import com.indeed.shaded.org.apache.el7.MethodExpressionLiteral;
import com.indeed.shaded.org.apache.el7.ValueExpressionImpl;
import com.indeed.shaded.org.apache.el7.lang.FunctionMapperFactory;
import com.indeed.shaded.org.apache.el7.lang.VariableMapperFactory;
import com.indeed.shaded.org.apache.el7.parser.AstDeferredExpression;
import com.indeed.shaded.org.apache.el7.parser.AstDynamicExpression;
import com.indeed.shaded.org.apache.el7.parser.AstFunction;
import com.indeed.shaded.org.apache.el7.parser.AstIdentifier;
import com.indeed.shaded.org.apache.el7.parser.AstLiteralExpression;
import com.indeed.shaded.org.apache.el7.parser.AstValue;
import com.indeed.shaded.org.apache.el7.parser.ELParser;
import com.indeed.shaded.org.apache.el7.parser.Node;
import com.indeed.shaded.org.apache.el7.parser.NodeVisitor;
import com.indeed.shaded.org.apache.el7.util.ConcurrentCache;
import com.indeed.shaded.org.apache.el7.util.MessageFactory;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ExpressionBuilder
implements NodeVisitor {
    private static final int CACHE_SIZE;
    private static final String CACHE_SIZE_PROP = "com.indeed.shaded.org.apache.el7.ExpressionBuilder.CACHE_SIZE";
    private static final ConcurrentCache<String, Node> cache;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private String expression;

    public ExpressionBuilder(String expression, ELContext ctx) throws ELException {
        this.expression = expression;
        FunctionMapper ctxFn = ctx.getFunctionMapper();
        VariableMapper ctxVar = ctx.getVariableMapper();
        if (ctxFn != null) {
            this.fnMapper = new FunctionMapperFactory(ctxFn);
        }
        if (ctxVar != null) {
            this.varMapper = new VariableMapperFactory(ctxVar);
        }
    }

    public static final Node createNode(String expr) throws ELException {
        Node n = ExpressionBuilder.createNodeInternal(expr);
        return n;
    }

    private static final Node createNodeInternal(String expr) throws ELException {
        if (expr == null) {
            throw new ELException(MessageFactory.get("error.null"));
        }
        Node n = cache.get(expr);
        if (n == null) {
            try {
                n = new ELParser(new StringReader(expr)).CompositeExpression();
                int numChildren = n.jjtGetNumChildren();
                if (numChildren == 1) {
                    n = n.jjtGetChild(0);
                } else {
                    Class<?> type = null;
                    Node child = null;
                    for (int i = 0; i < numChildren; ++i) {
                        child = n.jjtGetChild(i);
                        if (child instanceof AstLiteralExpression) continue;
                        if (type == null) {
                            type = child.getClass();
                            continue;
                        }
                        if (type.equals(child.getClass())) continue;
                        throw new ELException(MessageFactory.get("error.mixed", expr));
                    }
                }
                if (n instanceof AstDeferredExpression || n instanceof AstDynamicExpression) {
                    n = n.jjtGetChild(0);
                }
                cache.put(expr, n);
            }
            catch (Exception e) {
                throw new ELException(MessageFactory.get("error.parseFail", expr), e);
            }
        }
        return n;
    }

    private void prepare(Node node) throws ELException {
        try {
            node.accept(this);
        }
        catch (Exception e) {
            if (e instanceof ELException) {
                throw (ELException)e;
            }
            throw new ELException(e);
        }
        if (this.fnMapper instanceof FunctionMapperFactory) {
            this.fnMapper = ((FunctionMapperFactory)this.fnMapper).create();
        }
        if (this.varMapper instanceof VariableMapperFactory) {
            this.varMapper = ((VariableMapperFactory)this.varMapper).create();
        }
    }

    private Node build() throws ELException {
        Node n = ExpressionBuilder.createNodeInternal(this.expression);
        this.prepare(n);
        if (n instanceof AstDeferredExpression || n instanceof AstDynamicExpression) {
            n = n.jjtGetChild(0);
        }
        return n;
    }

    @Override
    public void visit(Node node) throws ELException {
        if (node instanceof AstFunction) {
            AstFunction funcNode = (AstFunction)node;
            if (this.fnMapper == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.null"));
            }
            Method m = this.fnMapper.resolveFunction(funcNode.getPrefix(), funcNode.getLocalName());
            if (m == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.method", funcNode.getOutputName()));
            }
            int methodParameterCount = m.getParameterTypes().length;
            int inputParameterCount = node.jjtGetNumChildren();
            if (m.isVarArgs() && inputParameterCount < methodParameterCount - 1 || !m.isVarArgs() && inputParameterCount != methodParameterCount) {
                throw new ELException(MessageFactory.get("error.fnMapper.paramcount", funcNode.getOutputName(), "" + methodParameterCount, "" + node.jjtGetNumChildren()));
            }
        } else if (node instanceof AstIdentifier && this.varMapper != null) {
            String variable = ((AstIdentifier)node).getImage();
            this.varMapper.resolveVariable(variable);
        }
    }

    public ValueExpression createValueExpression(Class<?> expectedType) throws ELException {
        Node n = this.build();
        return new ValueExpressionImpl(this.expression, n, this.fnMapper, this.varMapper, expectedType);
    }

    public MethodExpression createMethodExpression(Class<?> expectedReturnType, Class<?>[] expectedParamTypes) throws ELException {
        Node n = this.build();
        if (!n.isParametersProvided() && expectedParamTypes == null) {
            throw new NullPointerException(MessageFactory.get("error.method.nullParms"));
        }
        if (n instanceof AstValue || n instanceof AstIdentifier) {
            return new MethodExpressionImpl(this.expression, n, this.fnMapper, this.varMapper, expectedReturnType, expectedParamTypes);
        }
        if (n instanceof AstLiteralExpression) {
            return new MethodExpressionLiteral(this.expression, expectedReturnType, expectedParamTypes);
        }
        throw new ELException("Not a Valid Method Expression: " + this.expression);
    }

    static {
        String cacheSizeStr = System.getSecurityManager() == null ? System.getProperty(CACHE_SIZE_PROP, "5000") : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(ExpressionBuilder.CACHE_SIZE_PROP, "5000");
            }
        });
        CACHE_SIZE = Integer.parseInt(cacheSizeStr);
        cache = new ConcurrentCache(CACHE_SIZE);
    }
}

