/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.annotations.VisibleForTesting;
import com.indeed.proctor.common.ForceGroupsOptions;
import com.indeed.proctor.common.ForceGroupsOptionsStrings;
import com.indeed.proctor.common.Identifiers;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.TestType;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProctorConsumerUtils {
    public static final String FORCE_GROUPS_PARAMETER = "prforceGroups";
    public static final String FORCE_GROUPS_COOKIE_NAME = "prforceGroups";
    public static final String FORCE_GROUPS_HEADER = "X-PRFORCEGROUPS";
    private static final Logger LOGGER = LogManager.getLogger(ProctorConsumerUtils.class);
    @VisibleForTesting
    private static final Comparator<Cookie> COOKIE_COMPARATOR = Comparator.comparing(Cookie::getPath).thenComparing(Cookie::isHttpOnly).thenComparing(Cookie::getValue);

    public static ProctorResult determineBuckets(HttpServletRequest request, HttpServletResponse response, Proctor proctor, String identifier, TestType testType, Map<String, Object> context, boolean allowForcedGroups, Set<String> forcePayloadTests) {
        Identifiers identifiers = new Identifiers(testType, identifier);
        return ProctorConsumerUtils.determineBuckets(request, response, proctor, identifiers, context, allowForcedGroups, forcePayloadTests);
    }

    public static ProctorResult determineBuckets(HttpServletRequest request, HttpServletResponse response, Proctor proctor, Identifiers identifiers, Map<String, Object> context, boolean allowForcedGroups, Set<String> forcePayloadTests) {
        ForceGroupsOptions forceGroupsOptions;
        if (allowForcedGroups) {
            forceGroupsOptions = ProctorConsumerUtils.parseForcedGroupsOptions(request, forcePayloadTests);
            ProctorConsumerUtils.createForcedGroupsCookieUnlessEmpty(request.getContextPath(), forceGroupsOptions).ifPresent(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
        } else {
            forceGroupsOptions = ForceGroupsOptions.empty();
        }
        return proctor.determineTestGroups(identifiers, context, forceGroupsOptions, Collections.emptyList());
    }

    @Nonnull
    public static ForceGroupsOptions parseForcedGroupsOptions(@Nonnull HttpServletRequest request) {
        String forceGroupsList = ProctorConsumerUtils.getForceGroupsStringFromRequest(request);
        return ForceGroupsOptionsStrings.parseForceGroupsString((String)forceGroupsList, new HashSet());
    }

    @Nonnull
    public static ForceGroupsOptions parseForcedGroupsOptions(@Nonnull HttpServletRequest request, Set<String> forcePayloadTests) {
        String forceGroupsList = ProctorConsumerUtils.getForceGroupsStringFromRequest(request);
        return ForceGroupsOptionsStrings.parseForceGroupsString((String)forceGroupsList, forcePayloadTests);
    }

    @Nonnull
    public static Map<String, Integer> parseForceGroupsList(@Nullable String payload) {
        return ForceGroupsOptionsStrings.parseForceGroupsString((String)payload, Collections.emptySet()).getForceGroups();
    }

    @Nonnull
    public static String getForceGroupsStringFromRequest(@Nonnull HttpServletRequest request) {
        String param = request.getParameter("prforceGroups");
        if (param != null) {
            return param;
        }
        String header = request.getHeader(FORCE_GROUPS_HEADER);
        if (header != null) {
            return header;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return "";
        }
        return Arrays.stream(cookies).filter(Objects::nonNull).filter(x -> "prforceGroups".equals(x.getName())).map(Cookie::getValue).filter(Objects::nonNull).map(cookie -> {
            try {
                return URLDecoder.decode(cookie, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Could not parse force group cookie", (Throwable)e);
                return "";
            }
        }).collect(Collectors.joining(","));
    }

    public static Optional<Cookie> createForcedGroupsCookieUnlessEmpty(String contextPath, ForceGroupsOptions forceGroupsOptions) {
        if (forceGroupsOptions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ProctorConsumerUtils.doCreateForcedGroupsCookie(contextPath, forceGroupsOptions));
    }

    private static Cookie doCreateForcedGroupsCookie(String contextPath, ForceGroupsOptions forceGroupsOptions) {
        String cookieValue = '\"' + ForceGroupsOptionsStrings.generateForceGroupsStringForCookies((ForceGroupsOptions)forceGroupsOptions) + '\"';
        String cookiePath = StringUtils.isBlank((CharSequence)contextPath) ? "/" : contextPath;
        Cookie cookie = new Cookie("prforceGroups", cookieValue);
        cookie.setPath(cookiePath);
        return cookie;
    }

    @Deprecated
    @Nonnull
    public static Map<String, Integer> parseForcedGroups(@Nonnull HttpServletRequest request) {
        return ProctorConsumerUtils.parseForcedGroupsOptions(request, new HashSet<String>()).getForceGroups();
    }

    @Deprecated
    public static void setForcedGroupsCookie(HttpServletRequest request, HttpServletResponse response, Map<String, Integer> forceGroups) {
        ProctorConsumerUtils.createForcedGroupsCookieUnlessEmpty(request.getContextPath(), forceGroups).ifPresent(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
    }

    @Deprecated
    public static Optional<Cookie> createForcedGroupsCookieUnlessEmpty(String contextPath, Map<String, Integer> forceGroups) {
        return ProctorConsumerUtils.createForcedGroupsCookieUnlessEmpty(contextPath, ForceGroupsOptions.builder().putAllForceGroups(forceGroups).build());
    }

    @Deprecated
    public static Cookie createForcedGroupsCookie(String contextPath, Map<String, Integer> forceGroups) {
        return ProctorConsumerUtils.doCreateForcedGroupsCookie(contextPath, forceGroups);
    }

    @Deprecated
    private static Cookie doCreateForcedGroupsCookie(String contextPath, Map<String, Integer> forceGroups) {
        return ProctorConsumerUtils.doCreateForcedGroupsCookie(contextPath, ForceGroupsOptions.builder().putAllForceGroups(forceGroups).build());
    }
}

