/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.gen.ant;

import com.google.common.base.Strings;
import com.indeed.proctor.consumer.gen.CodeGenException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class TestGroupsGeneratorTask
extends Task {
    protected static final Logger LOGGER = Logger.getLogger(TestGroupsGeneratorTask.class);
    protected String input;
    protected String target;
    protected String packageName;
    protected String groupsClass;
    protected String specificationOutput;

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getGroupsClass() {
        return this.groupsClass;
    }

    public void setGroupsClass(String groupsClass) {
        this.groupsClass = groupsClass;
    }

    public String getSpecificationOutput() {
        return this.specificationOutput;
    }

    public void setSpecificationOutput(String specificationOutput) {
        this.specificationOutput = specificationOutput;
    }

    @Deprecated
    protected void totalSpecificationGenerator(File dir) throws CodeGenException {
        this.totalSpecificationGenerator(Arrays.asList(dir.listFiles()));
    }

    protected void totalSpecificationGenerator(List<File> files) throws CodeGenException {
        if (files == null || files.size() == 0) {
            throw new CodeGenException("No specifications file input");
        }
        ArrayList<File> providedContextFiles = new ArrayList<File>();
        for (File file : files) {
            if (!"providedcontext.json".equals(file.getName())) continue;
            providedContextFiles.add(file);
        }
        if (providedContextFiles.size() != 1) {
            throw new CodeGenException("Incorrect amount of providedcontext.json in specified input folder");
        }
        new File(this.specificationOutput.substring(0, this.specificationOutput.lastIndexOf(File.separator))).mkdirs();
        File specificationOutputFile = new File(this.specificationOutput);
        this.generateTotalSpecification(files, specificationOutputFile);
    }

    @Deprecated
    protected abstract void generateTotalSpecification(File var1, File var2) throws CodeGenException;

    protected abstract void generateTotalSpecification(List<File> var1, File var2) throws CodeGenException;

    public void execute() throws BuildException {
        String[] inputs = this.input.split(",");
        if (inputs.length == 0) {
            LOGGER.error((Object)"input shouldn't be empty");
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String input : inputs) {
            File inputFile = new File(input.trim());
            if (inputFile == null) {
                LOGGER.error((Object)"input not substituted with configured value");
                return;
            }
            if (inputFile.isDirectory()) {
                files.addAll(Arrays.asList(inputFile.listFiles()));
                continue;
            }
            files.add(inputFile);
        }
        if (Strings.isNullOrEmpty((String)this.getSpecificationOutput())) {
            if (files.size() == 1) {
                try {
                    this.generateFile();
                }
                catch (CodeGenException ex) {
                    throw new BuildException("Unable to generate code " + ex.toString(), (Throwable)ex);
                }
            }
            throw new BuildException("Undefined output folder for generated specification");
        }
        try {
            this.totalSpecificationGenerator(files);
        }
        catch (CodeGenException e) {
            throw new BuildException("Could not create total specification", (Throwable)e);
        }
    }

    protected abstract void generateFile() throws CodeGenException;
}

