/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordlog;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.indeed.lsmtree.recordlog.RecordLogDirectory;
import com.indeed.util.compress.CompressionCodec;
import com.indeed.util.io.BufferedFileDataOutputStream;
import com.indeed.util.serialization.Serializer;
import com.indeed.util.varexport.Export;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.joda.time.DateTime;

public class GenericRecordLogAppender<T> {
    private static final Logger log = Logger.getLogger(GenericRecordLogAppender.class);
    public static final String LAST_POSITION_KEY = "lastposition";
    public static final String MAX_SEGMENT_KEY = "maxsegment";
    private long lastPosition;
    private int maxSegment;
    private final RecordLogDirectory.Writer<T> writer;
    private final File lastPositionPath;
    private final File maxSegmentPath;
    private final File metadataPath;
    private final File file;
    private final ObjectMapper mapper = new ObjectMapper();

    public GenericRecordLogAppender(File file, Serializer<T> serializer, CompressionCodec codec, AtomicReference<Map<String, String>> metadataRef) throws IOException {
        this(file, serializer, codec, metadataRef, Long.MAX_VALUE);
    }

    public GenericRecordLogAppender(@Nonnull File file, @Nonnull Serializer<T> serializer, @Nonnull CompressionCodec codec, @Nullable AtomicReference<Map<String, String>> metadataRef, long rollFrequency) throws IOException {
        this.mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        this.file = file;
        this.lastPositionPath = new File(this.file, "lastposition.txt");
        this.maxSegmentPath = new File(file, "maxsegment.txt");
        this.metadataPath = new File(file, "metadata.json");
        if (this.metadataPath.exists()) {
            Map<String, String> metadata = GenericRecordLogAppender.readMetadata(this.metadataPath, this.mapper);
            if (metadataRef != null) {
                metadataRef.set(metadata);
            }
            this.lastPosition = Long.parseLong(metadata.get(LAST_POSITION_KEY));
            this.maxSegment = Integer.parseInt(metadata.get(MAX_SEGMENT_KEY));
            log.info((Object)("lastposition: " + this.lastPosition));
            log.info((Object)("maxsegment: " + this.maxSegment));
        } else {
            this.lastPosition = GenericRecordLogAppender.readLongFromFile(this.lastPositionPath, 0L);
            this.maxSegment = -1;
        }
        this.writer = this.maxSegment < 0 ? RecordLogDirectory.Writer.create(file, serializer, codec, rollFrequency) : RecordLogDirectory.Writer.create(file, serializer, codec, rollFrequency, this.maxSegment);
    }

    @Export(name="last-position", doc="Last address that was written to")
    public long getLastPosition() {
        return this.lastPosition;
    }

    @Export(name="max-segment", doc="Segment number that the last position is currently writing to")
    public int getMaxSegment() {
        return this.maxSegment;
    }

    @Export(name="max-segment-timestamp", doc="Timestamp of max segment written to record log directory")
    public long getMaxSegmentTimestamp() {
        return this.getSegmentPath(this.getMaxSegment()).lastModified();
    }

    @Export(name="max-segment-timestring", doc="Same as max-segment-timestamp but just in human readable form")
    public String getMaxSegmentTimestring() {
        return new DateTime(this.getMaxSegmentTimestamp()).toString();
    }

    private static Map<String, String> readMetadata(File metadataPath, ObjectMapper mapper) throws IOException {
        if (metadataPath.exists()) {
            LinkedHashMap ret = Maps.newLinkedHashMap();
            JsonNode node = mapper.readTree(Files.toString((File)metadataPath, (Charset)Charsets.UTF_8));
            Iterator iterator = node.getFields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ret.put(entry.getKey(), ((JsonNode)entry.getValue()).getTextValue());
            }
            return ret;
        }
        return null;
    }

    public File getSegmentPath(int segment) {
        return RecordLogDirectory.getSegmentPath(this.file, segment);
    }

    protected long writeOperation(T op) throws IOException {
        this.lastPosition = this.writer.append(op);
        return this.lastPosition;
    }

    public synchronized void flushWriter(@Nonnull Map<String, String> metadata) throws IOException {
        this.writer.roll();
        this.maxSegment = (int)(this.lastPosition >>> 36);
        metadata.put(LAST_POSITION_KEY, String.valueOf(this.lastPosition));
        metadata.put(MAX_SEGMENT_KEY, String.valueOf(this.maxSegment));
        GenericRecordLogAppender.writeStringToFile(this.metadataPath, this.mapper.writeValueAsString(metadata));
        GenericRecordLogAppender.writeStringToFile(this.lastPositionPath, String.valueOf(this.lastPosition));
        GenericRecordLogAppender.writeStringToFile(this.maxSegmentPath, String.valueOf(this.maxSegment));
    }

    public static long readLongFromFile(@Nonnull File f, long defaultVal) throws IOException {
        if (!f.exists()) {
            return defaultVal;
        }
        RandomAccessFile in = new RandomAccessFile(f, "r");
        int length = (int)in.length();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        in.close();
        return Long.parseLong(new String(bytes, Charsets.UTF_8).trim());
    }

    public static void writeStringToFile(File f, String str) throws IOException {
        File nextPath = new File(f.getParentFile(), f.getName() + ".next");
        BufferedFileDataOutputStream out = new BufferedFileDataOutputStream(nextPath);
        out.write(str.getBytes(Charsets.UTF_8));
        out.sync();
        out.close();
        nextPath.renameTo(f);
    }
}

