/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.primitives.Ints;
import com.indeed.lsmtree.core.Generation;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;

public final class MergingIterator<K, V>
extends AbstractIterator<Generation.Entry<K, V>> {
    private static final Logger log = Logger.getLogger(MergingIterator.class);
    private final PriorityQueue<PeekingIterator<EntryAndGenerationId<K, V>>> heap;
    private final List<PeekingIterator<EntryAndGenerationId<K, V>>> temp = Lists.newArrayList();
    private final Comparator<K> keyComparator;

    public MergingIterator(Collection<Iterator<Generation.Entry<K, V>>> iterators, final Comparator<K> keyComparator) {
        this.keyComparator = keyComparator;
        Comparator comparator = new Comparator<PeekingIterator<EntryAndGenerationId<K, V>>>(){

            @Override
            public int compare(PeekingIterator<EntryAndGenerationId<K, V>> o1, PeekingIterator<EntryAndGenerationId<K, V>> o2) {
                EntryAndGenerationId a = (EntryAndGenerationId)o1.peek();
                EntryAndGenerationId b = (EntryAndGenerationId)o2.peek();
                int cmp = keyComparator.compare(a.entry.getKey(), b.entry.getKey());
                if (cmp != 0) {
                    return cmp;
                }
                return Ints.compare((int)a.generationId, (int)b.generationId);
            }
        };
        this.heap = new PriorityQueue(iterators.size(), comparator);
        int i = 0;
        for (final Iterator<Generation.Entry<K, V>> iterator : iterators) {
            int generationId;
            PeekingIterator iter = Iterators.peekingIterator((Iterator)new Iterator<EntryAndGenerationId<K, V>>(generationId = i){
                Iterator<Generation.Entry<K, V>> it;
                final /* synthetic */ int val$generationId;
                {
                    this.val$generationId = n;
                    this.it = iterator;
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public EntryAndGenerationId<K, V> next() {
                    return new EntryAndGenerationId(this.it.next(), this.val$generationId);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
            if (iter.hasNext()) {
                this.heap.add(iter);
            }
            ++i;
        }
    }

    protected Generation.Entry<K, V> computeNext() {
        if (this.heap.isEmpty()) {
            return (Generation.Entry)this.endOfData();
        }
        PeekingIterator<EntryAndGenerationId<K, V>> first = this.heap.poll();
        EntryAndGenerationId ret = (EntryAndGenerationId)first.next();
        if (first.hasNext()) {
            this.temp.add(first);
        }
        while (!this.heap.isEmpty() && this.keyComparator.compare(ret.entry.getKey(), ((EntryAndGenerationId)this.heap.peek().peek()).entry.getKey()) == 0) {
            PeekingIterator<EntryAndGenerationId<K, V>> iter = this.heap.poll();
            iter.next();
            if (!iter.hasNext()) continue;
            this.temp.add(iter);
        }
        this.heap.addAll(this.temp);
        this.temp.clear();
        return ret.entry;
    }

    private static final class EntryAndGenerationId<K, V> {
        final Generation.Entry<K, V> entry;
        final int generationId;

        private EntryAndGenerationId(Generation.Entry<K, V> entry, int generationId) {
            this.entry = entry;
            this.generationId = generationId;
        }
    }
}

