/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.collect.Ordering;
import com.indeed.lsmtree.core.Generation;
import com.indeed.lsmtree.core.ItUtil;
import com.indeed.lsmtree.core.ReverseGeneration;
import com.indeed.util.core.reference.SharedReference;
import fj.F;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public final class FilteredGeneration<K, V>
implements Generation<K, V> {
    private static final Logger log = Logger.getLogger(FilteredGeneration.class);
    private final Generation<K, V> generation;
    private final SharedReference<Closeable> closeable;
    private final K minKey;
    private final boolean minInclusive;
    private final K maxKey;
    private final boolean maxInclusive;
    private final Ordering<K> ordering;
    private final F<Generation.Entry<K, V>, Boolean> checkMax;
    private final F<Generation.Entry<K, V>, Boolean> checkMin;

    public FilteredGeneration(Generation<K, V> generation, SharedReference<Closeable> closeable, @Nullable K minKey, boolean minInclusive, @Nullable K maxKey, boolean maxInclusive) {
        this.generation = generation;
        this.closeable = closeable;
        this.minKey = minKey;
        this.minInclusive = minInclusive;
        this.maxKey = maxKey;
        this.maxInclusive = maxInclusive;
        this.ordering = Ordering.from(generation.getComparator());
        this.checkMax = new F<Generation.Entry<K, V>, Boolean>(){

            public Boolean f(Generation.Entry<K, V> kvEntry) {
                int cmp = FilteredGeneration.this.ordering.compare(kvEntry.getKey(), FilteredGeneration.this.maxKey);
                return cmp <= 0 & (cmp != 0 | FilteredGeneration.this.maxInclusive);
            }
        };
        this.checkMin = new F<Generation.Entry<K, V>, Boolean>(){

            public Boolean f(Generation.Entry<K, V> kvEntry) {
                int cmp = FilteredGeneration.this.ordering.compare(kvEntry.getKey(), FilteredGeneration.this.minKey);
                return cmp >= 0 & (cmp != 0 | FilteredGeneration.this.minInclusive);
            }
        };
    }

    private boolean checkRange(K key) {
        int cmpMax;
        int cmpMin;
        int n = cmpMin = this.minKey == null ? 1 : this.ordering.compare(key, this.minKey);
        if (!(cmpMin > 0 || this.minInclusive && cmpMin >= 0)) {
            return false;
        }
        int n2 = cmpMax = this.maxKey == null ? -1 : this.ordering.compare(key, this.maxKey);
        return cmpMax < 0 || this.maxInclusive && cmpMax <= 0;
    }

    @Override
    public Generation.Entry get(K key) {
        if (!this.checkRange(key)) {
            return null;
        }
        return this.generation.get(key);
    }

    @Override
    public Boolean isDeleted(K key) {
        if (!this.checkRange(key)) {
            return null;
        }
        return this.generation.isDeleted(key);
    }

    @Override
    public Generation<K, V> head(K end, boolean inclusive) {
        return new FilteredGeneration<Object, V>(this, (SharedReference<Closeable>)this.closeable.copy(), null, false, end, inclusive);
    }

    @Override
    public Generation<K, V> tail(K start, boolean inclusive) {
        return new FilteredGeneration<Object, V>(this, (SharedReference<Closeable>)this.closeable.copy(), start, inclusive, null, false);
    }

    @Override
    public Generation<K, V> slice(K start, boolean startInclusive, K end, boolean endInclusive) {
        return new FilteredGeneration<K, V>(this, (SharedReference<Closeable>)this.closeable.copy(), start, startInclusive, end, endInclusive);
    }

    @Override
    public Generation<K, V> reverse() {
        return new ReverseGeneration(this, (SharedReference<Closeable>)this.closeable.copy());
    }

    @Override
    public Iterator<Generation.Entry<K, V>> iterator() {
        Iterator<Object> it = this.minKey == null ? this.generation.iterator() : this.generation.iterator(this.minKey, this.minInclusive);
        return this.maxKey == null ? it : (Iterator<Object>)ItUtil.span(this.checkMax, it)._1();
    }

    @Override
    public Iterator<Generation.Entry<K, V>> iterator(K start, boolean startInclusive) {
        if (this.minKey != null) {
            if (start == null) {
                start = this.minKey;
                startInclusive = this.minInclusive;
            } else {
                int cmp = this.ordering.compare(start, this.minKey);
                K k = start = cmp < 0 ? this.minKey : start;
                startInclusive = cmp == 0 ? this.minInclusive & startInclusive : (cmp < 0 ? this.minInclusive : startInclusive);
            }
        } else if (start == null) {
            return this.maxKey == null ? this.generation.iterator() : (Iterator)ItUtil.span(this.checkMax, this.generation.iterator())._1();
        }
        Iterator it = this.generation.iterator(start, startInclusive);
        return this.maxKey == null ? it : (Iterator)ItUtil.span(this.checkMax, it)._1();
    }

    @Override
    public Iterator<Generation.Entry<K, V>> reverseIterator() {
        Iterator<Object> it = this.maxKey == null ? this.generation.reverseIterator() : this.generation.reverseIterator(this.maxKey, this.maxInclusive);
        return this.minKey == null ? it : (Iterator<Object>)ItUtil.span(this.checkMin, it)._1();
    }

    @Override
    public Iterator<Generation.Entry<K, V>> reverseIterator(K start, boolean startInclusive) {
        if (this.maxKey != null) {
            if (start == null) {
                start = this.maxKey;
                startInclusive = this.maxInclusive;
            } else {
                int cmp = this.ordering.compare(start, this.maxKey);
                K k = start = cmp > 0 ? this.maxKey : start;
                startInclusive = cmp == 0 ? this.maxInclusive & startInclusive : (cmp > 0 ? this.maxInclusive : startInclusive);
            }
        } else if (start == null) {
            return this.minKey == null ? this.generation.reverseIterator() : (Iterator)ItUtil.span(this.checkMin, this.generation.reverseIterator())._1();
        }
        Iterator it = this.generation.reverseIterator(start, startInclusive);
        return this.minKey == null ? it : (Iterator)ItUtil.span(this.checkMin, it)._1();
    }

    @Override
    public Comparator<K> getComparator() {
        return this.ordering;
    }

    @Override
    public void close() throws IOException {
        this.closeable.close();
    }

    @Override
    public void delete() throws IOException {
        this.generation.delete();
    }

    @Override
    public void checkpoint(File checkpointPath) throws IOException {
        this.generation.checkpoint(checkpointPath);
    }

    @Override
    public File getPath() {
        return this.generation.getPath();
    }

    @Override
    public boolean hasDeletions() {
        return this.generation.hasDeletions();
    }

    @Override
    public long sizeInBytes() throws IOException {
        return this.generation.sizeInBytes();
    }

    @Override
    public long size() throws IOException {
        return this.generation.size();
    }
}

