/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Ordering;
import com.google.common.io.ByteStreams;
import com.indeed.lsmtree.core.FilteredGeneration;
import com.indeed.lsmtree.core.Generation;
import com.indeed.lsmtree.core.ReverseGeneration;
import com.indeed.lsmtree.core.TransactionLog;
import com.indeed.util.core.reference.SharedReference;
import com.indeed.util.io.BufferedFileDataOutputStream;
import com.indeed.util.serialization.Serializer;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public final class VolatileGeneration<K, V>
implements Generation<K, V> {
    private static final Logger log = Logger.getLogger(VolatileGeneration.class);
    private final TransactionLog.Writer transactionLog;
    private final Object deleted;
    private final ConcurrentSkipListMap<K, Object> map;
    private final File logPath;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final Ordering<K> ordering;
    private final SharedReference<Closeable> stuffToClose;

    public VolatileGeneration(File logPath, Serializer<K> keySerializer, Serializer<V> valueSerializer, Comparator<K> comparator) throws IOException {
        this(logPath, keySerializer, valueSerializer, comparator, false);
    }

    public VolatileGeneration(File logPath, Serializer<K> keySerializer, Serializer<V> valueSerializer, Comparator<K> comparator, boolean loadExistingReadOnly) throws IOException {
        this.ordering = Ordering.from(comparator);
        this.map = new ConcurrentSkipListMap(comparator);
        this.logPath = logPath;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.deleted = new Object();
        if (loadExistingReadOnly) {
            if (!logPath.exists()) {
                throw new IllegalArgumentException(logPath.getAbsolutePath() + " does not exist");
            }
            this.transactionLog = null;
            this.replayTransactionLog(logPath, true);
        } else {
            if (logPath.exists()) {
                throw new IllegalArgumentException("to load existing logs set loadExistingReadOnly to true or create a new log and use replayTransactionLog");
            }
            this.transactionLog = new TransactionLog.Writer<K, V>(logPath, keySerializer, valueSerializer, false);
        }
        this.stuffToClose = SharedReference.create((Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
                VolatileGeneration.this.closeWriter();
            }
        });
    }

    public void replayTransactionLog(File path) throws IOException {
        this.replayTransactionLog(path, false);
    }

    private void replayTransactionLog(File path, boolean readOnly) throws IOException {
        TransactionLog.Reader<K, V> reader = new TransactionLog.Reader<K, V>(path, this.keySerializer, this.valueSerializer);
        try {
            while (reader.next()) {
                K key = reader.getKey();
                switch (reader.getType()) {
                    case PUT: {
                        V value = reader.getValue();
                        if (!readOnly) {
                            this.transactionLog.put(key, value);
                        }
                        this.map.put(key, value);
                        break;
                    }
                    case DELETE: {
                        if (!readOnly) {
                            this.transactionLog.delete(key);
                        }
                        this.map.put(key, this.deleted);
                    }
                }
            }
        }
        catch (TransactionLog.LogClosedException e) {
            log.error((Object)"log is closed and it shouldn't be", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            reader.close();
            if (!readOnly) {
                this.transactionLog.sync();
            }
        }
    }

    public void put(K key, V value) throws IOException, TransactionLog.LogClosedException {
        this.transactionLog.put(key, value);
        this.map.put(key, value);
    }

    public void delete(K key) throws IOException, TransactionLog.LogClosedException {
        this.transactionLog.delete(key);
        this.map.put(key, this.deleted);
    }

    @Override
    public Generation.Entry<K, V> get(K key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (value == this.deleted) {
            return Generation.Entry.createDeleted(key);
        }
        return Generation.Entry.create(key, value);
    }

    @Override
    public Boolean isDeleted(K key) {
        Generation.Entry<K, V> result = this.get(key);
        return result == null ? null : (result.isDeleted() ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public Generation<K, V> head(K endKey, boolean inclusive) {
        return new FilteredGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy(), null, false, endKey, inclusive);
    }

    @Override
    public Generation<K, V> tail(K startKey, boolean inclusive) {
        return new FilteredGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy(), startKey, inclusive, null, false);
    }

    @Override
    public Generation<K, V> slice(K start, boolean startInclusive, K end, boolean endInclusive) {
        return new FilteredGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy(), start, startInclusive, end, endInclusive);
    }

    @Override
    public Generation<K, V> reverse() {
        return new ReverseGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy());
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public long sizeInBytes() throws IOException {
        return this.transactionLog == null ? 0L : this.transactionLog.sizeInBytes();
    }

    @Override
    public boolean hasDeletions() {
        return true;
    }

    @Override
    public Iterator<Generation.Entry<K, V>> iterator() {
        return this.iterator(null, false);
    }

    @Override
    public Iterator<Generation.Entry<K, V>> iterator(final @Nullable K start, final boolean startInclusive) {
        return new AbstractIterator<Generation.Entry<K, V>>(){
            boolean initialized = false;
            K key;

            protected Generation.Entry<K, V> computeNext() {
                Map.Entry entry;
                if (!this.initialized) {
                    this.initialized = true;
                    entry = start == null ? VolatileGeneration.this.map.firstEntry() : (startInclusive ? VolatileGeneration.this.map.ceilingEntry(start) : VolatileGeneration.this.map.higherEntry(start));
                } else {
                    entry = VolatileGeneration.this.map.higherEntry(this.key);
                }
                if (entry == null) {
                    return (Generation.Entry)this.endOfData();
                }
                this.key = entry.getKey();
                Object value = entry.getValue();
                if (value == VolatileGeneration.this.deleted) {
                    return Generation.Entry.createDeleted(this.key);
                }
                return Generation.Entry.create(this.key, value);
            }
        };
    }

    @Override
    public Iterator<Generation.Entry<K, V>> reverseIterator() {
        return this.reverseIterator(null, false);
    }

    @Override
    public Iterator<Generation.Entry<K, V>> reverseIterator(final @Nullable K start, final boolean startInclusive) {
        return new AbstractIterator<Generation.Entry<K, V>>(){
            boolean initialized = false;
            K key;

            protected Generation.Entry<K, V> computeNext() {
                Map.Entry entry;
                if (!this.initialized) {
                    this.initialized = true;
                    entry = start == null ? VolatileGeneration.this.map.lastEntry() : (startInclusive ? VolatileGeneration.this.map.floorEntry(start) : VolatileGeneration.this.map.lowerEntry(start));
                } else {
                    entry = VolatileGeneration.this.map.lowerEntry(this.key);
                }
                if (entry == null) {
                    return (Generation.Entry)this.endOfData();
                }
                this.key = entry.getKey();
                Object value = entry.getValue();
                if (value == VolatileGeneration.this.deleted) {
                    return Generation.Entry.createDeleted(this.key);
                }
                return Generation.Entry.create(this.key, value);
            }
        };
    }

    @Override
    public Comparator<K> getComparator() {
        return this.ordering;
    }

    public void sync() throws IOException {
        if (this.transactionLog != null) {
            this.transactionLog.sync();
        }
    }

    public void closeWriter() throws IOException {
        if (this.transactionLog != null) {
            this.transactionLog.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.stuffToClose.close();
    }

    @Override
    public void delete() throws IOException {
        log.info((Object)("deleting " + this.getPath()));
        this.getPath().delete();
    }

    @Override
    public File getPath() {
        return this.logPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkpoint(File checkpointPath) throws IOException {
        BufferedFileDataOutputStream out = null;
        InputStream in = null;
        try {
            out = new BufferedFileDataOutputStream(new File(checkpointPath, this.logPath.getName()));
            in = new BufferedInputStream(new FileInputStream(this.logPath), 65536);
            ByteStreams.copy((InputStream)in, (OutputStream)out);
            out.sync();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }
}

