/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.indeed.lsmtree.core.BloomFilter;
import com.indeed.lsmtree.core.FilteredGeneration;
import com.indeed.lsmtree.core.Generation;
import com.indeed.lsmtree.core.ImmutableBTreeIndex;
import com.indeed.lsmtree.core.MergingIterator;
import com.indeed.lsmtree.core.ReverseGeneration;
import com.indeed.lsmtree.core.RuntimeIOException;
import com.indeed.lsmtree.core.StorageType;
import com.indeed.lsmtree.recordlog.BlockCompressedRecordFile;
import com.indeed.util.compress.CompressionCodec;
import com.indeed.util.core.io.Closeables2;
import com.indeed.util.core.reference.SharedReference;
import com.indeed.util.core.shell.PosixFileOperations;
import com.indeed.util.serialization.LongSerializer;
import com.indeed.util.serialization.Serializer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public final class StableGeneration {
    private static final Logger log = Logger.getLogger(StableGeneration.class);

    public static <K, V> Generation<K, V> open(BloomFilter.MemoryManager memoryManager, File file, Comparator<K> comparator, Serializer<K> keySerializer, Serializer<V> valueSerializer, StorageType storageType, CompressionCodec codec, boolean mlockBTree) throws IOException {
        if (storageType == StorageType.BLOCK_COMPRESSED && codec == null) {
            throw new IllegalArgumentException("codec must be set if block compressed");
        }
        if (storageType == StorageType.INLINE) {
            return new InlineStableGeneration<K, V>(memoryManager, file, comparator, keySerializer, valueSerializer, mlockBTree);
        }
        if (storageType == StorageType.BLOCK_COMPRESSED) {
            return new BlockCompressedStableGeneration<K, V>(memoryManager, file, comparator, keySerializer, valueSerializer, codec, mlockBTree);
        }
        throw new IllegalArgumentException((Object)((Object)storageType) + " is not a valid storage type");
    }

    public static class Writer {
        public static <K, V> void write(BloomFilter.MemoryManager memoryManager, File path, List<Generation<K, V>> generations, Serializer<K> keySerializer, Serializer<V> valueSerializer, Comparator<K> keyComparator, StorageType storageType, CompressionCodec codec, boolean hasDeletions) throws IOException {
            Writer.write(memoryManager, path, generations, keySerializer, valueSerializer, keyComparator, storageType, codec, hasDeletions, true);
        }

        public static <K, V> void write(BloomFilter.MemoryManager memoryManager, File path, List<Generation<K, V>> generations, Serializer<K> keySerializer, Serializer<V> valueSerializer, Comparator<K> keyComparator, StorageType storageType, CompressionCodec codec, boolean hasDeletions, boolean useBloomFilter) throws IOException {
            ImmutableBTreeIndex.Reader<K, V> reader = null;
            if (storageType == StorageType.INLINE) {
                Iterator<Generation.Entry<K, V>> iterator = Writer.mergeIterators(generations, keyComparator);
                long start = System.nanoTime();
                ImmutableBTreeIndex.Writer.write(path, iterator, keySerializer, valueSerializer, 65536, hasDeletions);
                log.info((Object)("write b tree time: " + (double)(System.nanoTime() - start) / 1000.0 + " us"));
                if (useBloomFilter) {
                    reader = new ImmutableBTreeIndex.Reader<K, V>(path, keySerializer, valueSerializer, false);
                }
            } else if (storageType == StorageType.BLOCK_COMPRESSED) {
                path.mkdirs();
                File valuesFile = new File(path, "values.bin");
                final Iterator<Generation.Entry<K, V>> iterator = Writer.mergeIterators(generations, keyComparator);
                final BlockCompressedRecordFile.Writer writer = BlockCompressedRecordFile.Writer.open((File)valuesFile, valueSerializer, (CompressionCodec)codec, (int)16384, (int)10, (int)6);
                Iterator keyAddressIterator = new Iterator<Generation.Entry<K, Long>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Generation.Entry<K, Long> next() {
                        Generation.Entry next = (Generation.Entry)iterator.next();
                        try {
                            if (next.isDeleted()) {
                                return Generation.Entry.createDeleted(next.getKey());
                            }
                            return Generation.Entry.create(next.getKey(), writer.append(next.getValue()));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                LongSerializer longSerializer = new LongSerializer();
                long start = System.nanoTime();
                ImmutableBTreeIndex.Writer.write(path, keyAddressIterator, keySerializer, longSerializer, 65536, hasDeletions);
                writer.close();
                log.info((Object)("write b tree time: " + (double)(System.nanoTime() - start) / 1000.0 + " us"));
                if (useBloomFilter) {
                    reader = new ImmutableBTreeIndex.Reader(path, keySerializer, longSerializer, false);
                }
            }
            if (reader != null) {
                long start = System.nanoTime();
                if (reader.size() > 0L && reader.size() <= Integer.MAX_VALUE) {
                    File file = new File(path, "bloomfilter.bin");
                    try {
                        BloomFilter.Writer.write(memoryManager, file, reader.iterator(), keySerializer, reader.size());
                    }
                    catch (BloomFilter.NotEnoughMemoryException e) {
                        log.warn((Object)"not enough memory to write bloomfilter", (Throwable)e);
                        file.delete();
                    }
                }
                reader.close();
                log.info((Object)("write bloom filter time: " + (double)(System.nanoTime() - start) / 1000.0 + " us"));
            }
        }

        private static <K, V> Iterator<Generation.Entry<K, V>> mergeIterators(List<Generation<K, V>> generations, Comparator<K> keyComparator) throws IOException {
            return new MergingIterator(Lists.transform(generations, (Function)new Function<Generation<K, V>, Iterator<Generation.Entry<K, V>>>(){

                public Iterator<Generation.Entry<K, V>> apply(Generation<K, V> input) {
                    return input.iterator();
                }
            }), keyComparator);
        }
    }

    public static class BlockCompressedStableGeneration<K, V>
    implements Generation<K, V> {
        private final BloomFilter.Reader bloomFilter;
        private final ImmutableBTreeIndex.Reader<K, Long> reader;
        private final BlockCompressedRecordFile<V> recordFile;
        private final File file;
        private final long sizeInBytes;
        private final SharedReference<Closeable> stuffToClose;

        public BlockCompressedStableGeneration(BloomFilter.MemoryManager memoryManager, File file, Comparator<K> comparator, Serializer<K> keySerializer, Serializer<V> valueSerializer, CompressionCodec codec, boolean mlockBTree) throws IOException {
            this.file = file;
            this.reader = new ImmutableBTreeIndex.Reader(file, comparator, keySerializer, new LongSerializer(), mlockBTree);
            File valuesFile = new File(file, "values.bin");
            this.recordFile = new BlockCompressedRecordFile.Builder(valuesFile, valueSerializer, codec).setMlockFiles(mlockBTree).build();
            File bloomFilterFile = new File(file, "bloomfilter.bin");
            this.bloomFilter = bloomFilterFile.exists() ? new BloomFilter.Reader<K>(memoryManager, bloomFilterFile, keySerializer) : null;
            this.sizeInBytes = this.reader.sizeInBytes() + valuesFile.length() + (this.bloomFilter == null ? 0L : this.bloomFilter.sizeInBytes());
            this.stuffToClose = SharedReference.create((Closeable)new Closeable(){

                @Override
                public void close() throws IOException {
                    Closeables2.closeQuietly((Closeable)BlockCompressedStableGeneration.this.reader, (Logger)log);
                    if (BlockCompressedStableGeneration.this.bloomFilter != null) {
                        Closeables2.closeQuietly((Closeable)BlockCompressedStableGeneration.this.bloomFilter, (Logger)log);
                    }
                    Closeables2.closeQuietly((Closeable)BlockCompressedStableGeneration.this.recordFile, (Logger)log);
                }
            });
        }

        @Override
        public Generation.Entry<K, V> get(K key) {
            if (this.bloomFilter == null || this.bloomFilter.contains(key)) {
                Generation.Entry<K, Long> result = this.reader.get(key);
                if (result == null) {
                    return null;
                }
                return this.lookupValue(result);
            }
            return null;
        }

        @Override
        @Nullable
        public Boolean isDeleted(K key) {
            if (this.bloomFilter == null || this.bloomFilter.contains(key)) {
                Generation.Entry<K, Long> result = this.reader.get(key);
                return result == null ? null : (result.isDeleted() ? Boolean.TRUE : Boolean.FALSE);
            }
            return null;
        }

        private Generation.Entry<K, V> lookupValue(Generation.Entry<K, Long> result) {
            if (result.isDeleted()) {
                return Generation.Entry.createDeleted(result.getKey());
            }
            try {
                return Generation.Entry.create(result.getKey(), this.recordFile.get(result.getValue().longValue()));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public Generation<K, V> head(K end, boolean inclusive) {
            return new FilteredGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy(), null, false, end, inclusive);
        }

        @Override
        public Generation<K, V> tail(K start, boolean inclusive) {
            return new FilteredGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy(), start, inclusive, null, false);
        }

        @Override
        public Generation<K, V> slice(K start, boolean startInclusive, K end, boolean endInclusive) {
            return new FilteredGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy(), start, startInclusive, end, endInclusive);
        }

        @Override
        public Generation<K, V> reverse() {
            return new ReverseGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy());
        }

        @Override
        public Iterator<Generation.Entry<K, V>> iterator() {
            return this.iterator(this.reader.iterator());
        }

        @Override
        public Iterator<Generation.Entry<K, V>> iterator(K start, boolean startInclusive) {
            return this.iterator(this.reader.iterator(start, startInclusive));
        }

        private Iterator<Generation.Entry<K, V>> iterator(final Iterator<Generation.Entry<K, Long>> it) {
            return new Iterator<Generation.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Generation.Entry<K, V> next() {
                    Generation.Entry next = (Generation.Entry)it.next();
                    return BlockCompressedStableGeneration.this.lookupValue(next);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterator<Generation.Entry<K, V>> reverseIterator() {
            return this.iterator(this.reader.reverseIterator());
        }

        @Override
        public Iterator<Generation.Entry<K, V>> reverseIterator(K start, boolean startInclusive) {
            return this.iterator(this.reader.reverseIterator(start, startInclusive));
        }

        @Override
        public long size() {
            return this.reader.size();
        }

        @Override
        public long sizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public boolean hasDeletions() {
            return this.reader.hasDeletions();
        }

        @Override
        public Comparator<K> getComparator() {
            return this.reader.getComparator();
        }

        @Override
        public void close() throws IOException {
            this.stuffToClose.close();
        }

        @Override
        public void delete() throws IOException {
            log.info((Object)("deleting " + this.getPath()));
            PosixFileOperations.rmrf((File)this.getPath());
        }

        @Override
        public File getPath() {
            return this.file;
        }

        @Override
        public void checkpoint(File checkpointPath) throws IOException {
            PosixFileOperations.cplr((File)this.file, (File)checkpointPath);
        }
    }

    public static class InlineStableGeneration<K, V>
    implements Generation<K, V> {
        private final BloomFilter.Reader bloomFilter;
        private final ImmutableBTreeIndex.Reader<K, V> reader;
        private final File file;

        public InlineStableGeneration(BloomFilter.MemoryManager memoryManager, File file, Comparator<K> comparator, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean mlockBTree) throws IOException {
            this.file = file;
            this.reader = new ImmutableBTreeIndex.Reader<K, V>(file, comparator, keySerializer, valueSerializer, mlockBTree);
            File bloomFilterFile = new File(file, "bloomfilter.bin");
            this.bloomFilter = bloomFilterFile.exists() ? new BloomFilter.Reader<K>(memoryManager, bloomFilterFile, keySerializer) : null;
        }

        @Override
        public Generation.Entry<K, V> get(K key) {
            if (this.bloomFilter == null || this.bloomFilter.contains(key)) {
                return this.reader.get(key);
            }
            return null;
        }

        @Override
        @Nullable
        public Boolean isDeleted(K key) {
            Generation.Entry<K, V> entry = this.get(key);
            return entry == null ? null : (entry.isDeleted() ? Boolean.TRUE : Boolean.FALSE);
        }

        @Override
        public Generation<K, V> head(K end, boolean inclusive) {
            return this.reader.head(end, inclusive);
        }

        @Override
        public Generation<K, V> tail(K start, boolean inclusive) {
            return this.reader.tail(start, inclusive);
        }

        @Override
        public Generation<K, V> slice(K start, boolean startInclusive, K end, boolean endInclusive) {
            return this.reader.slice(start, startInclusive, end, endInclusive);
        }

        @Override
        public Generation<K, V> reverse() {
            return this.reader.reverse();
        }

        @Override
        public Iterator<Generation.Entry<K, V>> iterator() {
            return this.reader.iterator();
        }

        @Override
        public Iterator<Generation.Entry<K, V>> iterator(K start, boolean startInclusive) {
            return this.reader.iterator(start, startInclusive);
        }

        @Override
        public Iterator<Generation.Entry<K, V>> reverseIterator() {
            return this.reader.reverseIterator();
        }

        @Override
        public Iterator<Generation.Entry<K, V>> reverseIterator(K start, boolean startInclusive) {
            return this.reader.reverseIterator(start, startInclusive);
        }

        @Override
        public Comparator<K> getComparator() {
            return this.reader.getComparator();
        }

        @Override
        public long size() {
            return this.reader.size();
        }

        @Override
        public long sizeInBytes() {
            return this.reader.sizeInBytes() + (this.bloomFilter == null ? 0L : this.bloomFilter.sizeInBytes());
        }

        @Override
        public boolean hasDeletions() {
            return this.reader.hasDeletions();
        }

        @Override
        public void close() throws IOException {
            Closeables2.closeQuietly(this.reader, (Logger)log);
            if (this.bloomFilter != null) {
                Closeables2.closeQuietly((Closeable)this.bloomFilter, (Logger)log);
            }
        }

        @Override
        public void delete() throws IOException {
            log.info((Object)("deleting " + this.getPath()));
            PosixFileOperations.rmrf((File)this.getPath());
        }

        @Override
        public File getPath() {
            return this.file;
        }

        @Override
        public void checkpoint(File checkpointPath) throws IOException {
            PosixFileOperations.cplr((File)this.file, (File)checkpointPath);
        }
    }
}

