/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.indeed.lsmtree.core.FilteredGeneration;
import com.indeed.lsmtree.core.Generation;
import com.indeed.lsmtree.core.ReverseGeneration;
import com.indeed.util.core.io.Closeables2;
import com.indeed.util.core.reference.SharedReference;
import com.indeed.util.core.shell.PosixFileOperations;
import com.indeed.util.io.BufferedFileDataOutputStream;
import com.indeed.util.mmap.MMapBuffer;
import com.indeed.util.mmap.Memory;
import com.indeed.util.mmap.MemoryDataInput;
import com.indeed.util.serialization.LongSerializer;
import com.indeed.util.serialization.Serializer;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.log4j.Logger;

public final class ImmutableBTreeIndex {
    private static final Logger log = Logger.getLogger(ImmutableBTreeIndex.class);

    private static class Header {
        int indexLevels;
        long rootLevelStartAddress;
        long valueLevelLength;
        long size;
        boolean hasDeletions;
        long fileLength;

        private Header() {
        }

        private Header(int indexLevels, long rootLevelStartAddress, long valueLevelLength, long size, boolean hasDeletions, long fileLength) {
            this.indexLevels = indexLevels;
            this.rootLevelStartAddress = rootLevelStartAddress;
            this.valueLevelLength = valueLevelLength;
            this.size = size;
            this.hasDeletions = hasDeletions;
            this.fileLength = fileLength;
        }

        public static int length() {
            return 37;
        }

        public String toString() {
            return "Header{indexLevels=" + this.indexLevels + ", rootLevelStartAddress=" + this.rootLevelStartAddress + ", valueLevelLength=" + this.valueLevelLength + ", size=" + this.size + ", hasDeletions=" + this.hasDeletions + ", fileLength=" + this.fileLength + '}';
        }
    }

    private static class HeaderSerializer
    implements Serializer<Header> {
        private HeaderSerializer() {
        }

        public void write(Header header, DataOutput out) throws IOException {
            out.writeInt(header.indexLevels);
            out.writeLong(header.rootLevelStartAddress);
            out.writeLong(header.valueLevelLength);
            out.writeLong(header.size);
            out.writeByte(header.hasDeletions ? 1 : 0);
            out.writeLong(header.fileLength);
        }

        public Header read(DataInput in) throws IOException {
            int indexLevels = in.readInt();
            long rootLevelStartAddress = in.readLong();
            long valueLevelLength = in.readLong();
            long size = in.readLong();
            boolean hasDeletions = in.readByte() != 0;
            long fileLength = in.readLong();
            return new Header(indexLevels, rootLevelStartAddress, valueLevelLength, size, hasDeletions, fileLength);
        }
    }

    public static final class Reader<K, V>
    implements Generation<K, V>,
    Closeable {
        private final MMapBuffer buffer;
        private final Level<K, V> rootLevel;
        private final long rootLevelStartAddress;
        private final boolean hasDeletions;
        private final long sizeInBytes;
        private final long size;
        private final Path indexFile;
        private final Comparator<K> comparator;
        private final SharedReference<Closeable> stuffToClose;
        private static final NeighborModifier lower = new NeighborModifier(-1, -1);
        private static final NeighborModifier floor = new NeighborModifier(0, -1);
        private static final NeighborModifier ceil = new NeighborModifier(0, 0);
        private static final NeighborModifier higher = new NeighborModifier(1, 0);

        public Reader(File file, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean mlockFiles) throws IOException {
            this(file.toPath(), keySerializer, valueSerializer, mlockFiles);
        }

        public Reader(Path path, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean mlockFiles) throws IOException {
            this(path, (Comparator<K>)new ComparableComparator(), keySerializer, valueSerializer, mlockFiles);
        }

        public Reader(File file, Comparator<K> comparator, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean mlockFiles) throws IOException {
            this(file.toPath(), comparator, keySerializer, valueSerializer, mlockFiles);
        }

        public Reader(Path path, Comparator<K> comparator, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean mlockFiles) throws IOException {
            this.comparator = comparator;
            this.indexFile = path.resolve("index.bin");
            this.sizeInBytes = Files.size(this.indexFile);
            this.buffer = new MMapBuffer(this.indexFile, FileChannel.MapMode.READ_ONLY, ByteOrder.LITTLE_ENDIAN);
            try {
                this.stuffToClose = SharedReference.create((Closeable)this.buffer);
                MemoryDataInput in = new MemoryDataInput((Memory)this.buffer.memory());
                if (this.sizeInBytes < (long)Header.length()) {
                    throw new IOException("file is less than header length bytes");
                }
                byte[] headerBytes = new byte[Header.length()];
                in.seek(this.sizeInBytes - (long)Header.length());
                in.readFully(headerBytes);
                LittleEndianDataInputStream headerStream = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(headerBytes));
                Header header = new HeaderSerializer().read((DataInput)headerStream);
                this.hasDeletions = header.hasDeletions;
                this.size = header.size;
                if (header.fileLength != this.sizeInBytes) {
                    log.error((Object)header.fileLength);
                    throw new IOException("file length written to last 8 bytes of file does not match file length, file is inconsistent");
                }
                this.rootLevel = Level.build((Memory)this.buffer.memory(), keySerializer, valueSerializer, comparator, header.hasDeletions, header.indexLevels);
                this.rootLevelStartAddress = header.rootLevelStartAddress;
                if (mlockFiles) {
                    this.buffer.mlock(0L, this.buffer.memory().length());
                }
            }
            catch (Throwable t) {
                Closeables2.closeQuietly((Closeable)this.buffer, (Logger)log);
                Throwables.propagateIfInstanceOf((Throwable)t, IOException.class);
                throw Throwables.propagate((Throwable)t);
            }
        }

        private Block<K, V> rootBlock() {
            return new Block<K, V>(null, 0, this.rootLevel, this.rootLevel.getBlock(this.rootLevelStartAddress));
        }

        @Override
        @Nullable
        public Generation.Entry<K, V> get(K key) {
            try {
                Block<K, V> valueBlock = this.rootBlock().getValueBlock(key);
                if (valueBlock == null) {
                    return null;
                }
                return valueBlock.get(key);
            }
            catch (InternalError e) {
                throw new RuntimeException("file " + this.indexFile.normalize() + " length is currently less than MMapBuffer length, it has been modified after open. this is a huge problem.", e);
            }
        }

        @Override
        @Nullable
        public Boolean isDeleted(K key) {
            Generation.Entry<K, V> entry = this.get(key);
            return entry == null ? null : (entry.isDeleted() ? Boolean.TRUE : Boolean.FALSE);
        }

        @Nullable
        public Generation.Entry<K, V> lower(K key) throws IOException {
            return this.neighbor(key, lower);
        }

        @Nullable
        public Generation.Entry<K, V> floor(K key) throws IOException {
            return this.neighbor(key, floor);
        }

        @Nullable
        public Generation.Entry<K, V> ceil(K key) throws IOException {
            return this.neighbor(key, ceil);
        }

        @Nullable
        public Generation.Entry<K, V> higher(K key) throws IOException {
            return this.neighbor(key, higher);
        }

        @Nullable
        private Generation.Entry<K, V> neighbor(K key, NeighborModifier modifier) throws IOException {
            try {
                Block<K, V> valueBlock = this.rootBlock().getValueBlock(key);
                if (valueBlock == null) {
                    return null;
                }
                return valueBlock.neighbor(key, modifier);
            }
            catch (InternalError e) {
                throw new IOException("file " + this.indexFile.normalize() + " length is currently less than MMapBuffer length, it has been modified after open. this is a huge problem.", e);
            }
        }

        public Generation.Entry<K, V> first() throws IOException {
            try {
                Block<K, V> valueBlock = this.rootBlock().getFirstValueBlock();
                return valueBlock.dataBlock.getEntry(0);
            }
            catch (InternalError e) {
                throw new IOException("file " + this.indexFile.normalize() + " length is currently less than MMapBuffer length, it has been modified after open. this is a huge problem.", e);
            }
        }

        public Generation.Entry<K, V> last() throws IOException {
            try {
                Block<K, V> valueBlock = this.rootBlock().getLastValueBlock();
                return valueBlock.dataBlock.getEntry(valueBlock.length() - 1);
            }
            catch (InternalError e) {
                throw new IOException("file " + this.indexFile.normalize() + " length is currently less than MMapBuffer length, it has been modified after open. this is a huge problem.", e);
            }
        }

        @Override
        public Generation<K, V> head(K end, boolean inclusive) {
            return new FilteredGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy(), null, false, end, inclusive);
        }

        @Override
        public Generation<K, V> tail(K start, boolean inclusive) {
            return new FilteredGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy(), start, inclusive, null, false);
        }

        @Override
        public Generation<K, V> slice(K start, boolean startInclusive, K end, boolean endInclusive) {
            return new FilteredGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy(), start, startInclusive, end, endInclusive);
        }

        @Override
        public Generation<K, V> reverse() {
            return new ReverseGeneration(this, (SharedReference<Closeable>)this.stuffToClose.copy());
        }

        @Override
        public Iterator<Generation.Entry<K, V>> iterator() {
            return this.iterator(null, false);
        }

        @Override
        public Iterator<Generation.Entry<K, V>> iterator(final @Nullable K start, final boolean startInclusive) {
            return new AbstractIterator<Generation.Entry<K, V>>(){
                Block<K, V> current = null;
                int currentIndex;

                protected Generation.Entry<K, V> computeNext() {
                    if (this.current == null) {
                        Block rootBlock = Reader.this.rootBlock();
                        if (rootBlock == null) {
                            return (Generation.Entry)this.endOfData();
                        }
                        if (start != null) {
                            this.current = rootBlock.getValueBlock(start);
                            if (this.current != null) {
                                int insertionPoint = this.current.search(start);
                                this.currentIndex = insertionPoint >= 0 ? (startInclusive ? insertionPoint : insertionPoint + 1) : ~insertionPoint;
                            }
                        }
                        if (this.current == null) {
                            this.current = rootBlock.getFirstValueBlock();
                            this.currentIndex = 0;
                        }
                    }
                    if (this.currentIndex >= this.current.length()) {
                        this.current = this.current.nextBlock();
                        if (this.current == null) {
                            return (Generation.Entry)this.endOfData();
                        }
                        this.currentIndex = 0;
                    }
                    Generation.Entry ret = this.current.getEntry(this.currentIndex);
                    ++this.currentIndex;
                    return ret;
                }
            };
        }

        @Override
        public Iterator<Generation.Entry<K, V>> reverseIterator() {
            return this.reverseIterator(null, false);
        }

        @Override
        public Iterator<Generation.Entry<K, V>> reverseIterator(final @Nullable K start, final boolean startInclusive) {
            return new AbstractIterator<Generation.Entry<K, V>>(){
                Block current = null;
                int currentIndex;

                protected Generation.Entry<K, V> computeNext() {
                    if (this.current == null) {
                        Block rootBlock = Reader.this.rootBlock();
                        if (rootBlock == null) {
                            return (Generation.Entry)this.endOfData();
                        }
                        if (start == null) {
                            this.current = rootBlock.getLastValueBlock();
                            this.currentIndex = this.current.length() - 1;
                        } else {
                            this.current = rootBlock.getValueBlock(start);
                            if (this.current == null) {
                                return (Generation.Entry)this.endOfData();
                            }
                            int insertionPoint = this.current.search(start);
                            this.currentIndex = insertionPoint >= 0 ? (startInclusive ? insertionPoint : insertionPoint - 1) : ~insertionPoint - 1;
                        }
                    }
                    if (this.currentIndex < 0) {
                        this.current = this.current.previousBlock();
                        if (this.current == null) {
                            return (Generation.Entry)this.endOfData();
                        }
                        this.currentIndex = this.current.length() - 1;
                    }
                    Generation.Entry ret = this.current.getEntry(this.currentIndex);
                    --this.currentIndex;
                    return ret;
                }
            };
        }

        @Override
        public Comparator<K> getComparator() {
            return this.comparator;
        }

        @Override
        @Deprecated
        public File getPath() {
            return this.indexFile.toFile();
        }

        public Path getIndexPath() {
            return this.indexFile;
        }

        @Override
        public void checkpoint(File checkpointPath) throws IOException {
            PosixFileOperations.cplr((Path)this.indexFile, (Path)checkpointPath.toPath());
        }

        @Override
        public void delete() throws IOException {
            Files.delete(this.indexFile);
        }

        @Override
        public long sizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public void close() throws IOException {
            this.stuffToClose.close();
        }

        @Override
        public boolean hasDeletions() {
            return this.hasDeletions;
        }

        private static final class Level<K, V> {
            final Memory memory;
            final Level<K, V> nextLevel;
            final Serializer<K> keySerializer;
            final Serializer valueSerializer;
            final Comparator<K> comparator;
            final boolean hasDeletions;

            static <K, V> Level<K, V> build(Memory memory, Serializer<K> keySerializer, Serializer<V> valueSerializer, Comparator<K> comparator, boolean hasDeletions, int numLevels) {
                if (numLevels == 0) {
                    return new Level<K, V>(memory, null, keySerializer, valueSerializer, comparator, hasDeletions);
                }
                return new Level<K, V>(memory, Level.build(memory, keySerializer, valueSerializer, comparator, hasDeletions, numLevels - 1), keySerializer, (Serializer)new LongSerializer(), comparator, false);
            }

            Level(Memory memory, @Nullable Level<K, V> nextLevel, Serializer<K> keySerializer, Serializer valueSerializer, Comparator<K> comparator, boolean hasDeletions) {
                this.memory = memory;
                this.nextLevel = nextLevel;
                this.keySerializer = keySerializer;
                this.valueSerializer = valueSerializer;
                this.comparator = comparator;
                this.hasDeletions = hasDeletions;
            }

            boolean isValueLevel() {
                return this.nextLevel == null;
            }

            DataBlock getBlock(long address) {
                return new DataBlock(address);
            }

            final class DataBlock {
                final int length;
                final long offsetStart;
                final long kvStart;
                final MemoryDataInput in;

                DataBlock(long blockStart) {
                    this.length = Level.this.memory.getInt(blockStart);
                    this.offsetStart = blockStart + 4L;
                    this.kvStart = this.offsetStart + (long)(2 * this.length);
                    this.in = new MemoryDataInput(Level.this.memory);
                }

                K getKey(int index) {
                    char offset = Level.this.memory.getChar(this.offsetStart + (long)(2 * index));
                    this.in.seek(this.kvStart + (long)offset);
                    try {
                        return Level.this.keySerializer.read((DataInput)this.in);
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }

                Generation.Entry<K, Object> getEntry(int index) {
                    char offset = Level.this.memory.getChar(this.offsetStart + (long)(2 * index));
                    this.in.seek(this.kvStart + (long)offset);
                    try {
                        boolean isDeleted;
                        Object key = Level.this.keySerializer.read((DataInput)this.in);
                        boolean bl = isDeleted = Level.this.hasDeletions && this.in.readBoolean();
                        if (isDeleted) {
                            return Generation.Entry.createDeleted(key);
                        }
                        return Generation.Entry.create(key, Level.this.valueSerializer.read((DataInput)this.in));
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }

                int length() {
                    return this.length;
                }

                @Nullable
                Generation.Entry<K, Object> get(K key) {
                    int insertionPoint = this.search(key);
                    if (insertionPoint >= 0) {
                        return this.getEntry(insertionPoint);
                    }
                    return null;
                }

                int search(K key) {
                    int low = 0;
                    int high = this.length - 1;
                    while (low <= high) {
                        int mid = low + high >>> 1;
                        Object midVal = this.getKey(mid);
                        int cmp = Level.this.comparator.compare(midVal, key);
                        if (cmp < 0) {
                            low = mid + 1;
                            continue;
                        }
                        if (cmp > 0) {
                            high = mid - 1;
                            continue;
                        }
                        return mid;
                    }
                    return ~low;
                }
            }
        }

        private static final class NeighborModifier {
            final int addFound;
            final int addNotFound;

            private NeighborModifier(int addFound, int addNotFound) {
                this.addFound = addFound;
                this.addNotFound = addNotFound;
            }
        }

        private static final class High<K, V>
        implements SearchResult<K, V> {
            static final High high = new High();

            private High() {
            }

            static <K, V> High<K, V> high() {
                return high;
            }

            @Override
            public <Z> Z match(SearchResult.Matcher<K, V, Z> m) {
                return m.high();
            }
        }

        private static final class Low<K, V>
        implements SearchResult<K, V> {
            static final Low low = new Low();

            private Low() {
            }

            static <K, V> Low<K, V> low() {
                return low;
            }

            @Override
            public <Z> Z match(SearchResult.Matcher<K, V, Z> m) {
                return m.low();
            }
        }

        private static final class Found<K, V>
        implements SearchResult<K, V> {
            final Generation.Entry<K, V> entry;

            private Found(Generation.Entry<K, V> entry) {
                this.entry = entry;
            }

            @Override
            public <Z> Z match(SearchResult.Matcher<K, V, Z> m) {
                return m.found(this.entry);
            }
        }

        private static interface SearchResult<K, V> {
            public <Z> Z match(Matcher<K, V, Z> var1);

            public static abstract class Matcher<K, V, Z> {
                Z found(Generation.Entry<K, V> entry) {
                    return this.otherwise();
                }

                Z low() {
                    return this.otherwise();
                }

                Z high() {
                    return this.otherwise();
                }

                Z otherwise() {
                    throw new UnsupportedOperationException();
                }
            }
        }

        private static final class Block<K, V> {
            final Block<K, V> parent;
            final int parentPosition;
            final Level<K, V> level;
            final Level.DataBlock dataBlock;

            Block(@Nullable Block<K, V> parent, int parentPosition, Level<K, V> level, Level.DataBlock dataBlock) {
                this.parent = parent;
                this.parentPosition = parentPosition;
                this.level = level;
                this.dataBlock = dataBlock;
            }

            boolean isValueLevel() {
                return this.level.isValueLevel();
            }

            @Nullable
            Block<K, V> getChildBlock(int index) {
                Level nextLevel = (Level)Preconditions.checkNotNull(this.level.nextLevel);
                if (index >= this.dataBlock.length()) {
                    if (index == this.dataBlock.length()) {
                        Block<K, V> nextBlock = this.nextBlock();
                        return nextBlock == null ? null : nextBlock.getChildBlock(0);
                    }
                    throw new RuntimeException();
                }
                if (index < 0) {
                    if (index == -1) {
                        Block<K, V> previousBlock = this.previousBlock();
                        return previousBlock == null ? null : previousBlock.getChildBlock(previousBlock.dataBlock.length - 1);
                    }
                    throw new RuntimeException();
                }
                Long address = (Long)this.dataBlock.getEntry(index).getValue();
                return new Block<K, V>(this, index, nextLevel, nextLevel.getBlock(address));
            }

            int length() {
                return this.dataBlock.length();
            }

            @Nullable
            Block<K, V> nextBlock() {
                return this.parent == null ? null : this.parent.getChildBlock(this.parentPosition + 1);
            }

            @Nullable
            Block<K, V> previousBlock() {
                return this.parent == null ? null : this.parent.getChildBlock(this.parentPosition - 1);
            }

            @Nullable
            Block<K, V> getContainingBlock(K key) {
                final Level nextLevel = (Level)Preconditions.checkNotNull(this.level.nextLevel);
                final int floorIndex = this.neighborIndex(key, floor);
                SearchResult searchResult = this.getSearchResult(floorIndex);
                return (Block)searchResult.match(new SearchResult.Matcher<K, Long, Block<K, V>>(){

                    @Override
                    Block<K, V> found(Generation.Entry<K, Long> floor) {
                        return new Block(Block.this, floorIndex, nextLevel, nextLevel.getBlock(floor.getValue()));
                    }

                    @Override
                    @Nullable
                    Block<K, V> low() {
                        return null;
                    }
                });
            }

            @Nullable
            Block<K, V> getValueBlock(K key) {
                if (this.isValueLevel()) {
                    return this;
                }
                Block<K, V> containingBlock = this.getContainingBlock(key);
                if (containingBlock == null) {
                    return null;
                }
                return containingBlock.getValueBlock(key);
            }

            Block<K, V> getFirstValueBlock() {
                if (this.isValueLevel()) {
                    return this;
                }
                Block childBlock = (Block)Preconditions.checkNotNull(this.getChildBlock(0));
                return childBlock.getFirstValueBlock();
            }

            Block<K, V> getLastValueBlock() {
                if (this.isValueLevel()) {
                    return this;
                }
                Block childBlock = (Block)Preconditions.checkNotNull(this.getChildBlock(this.length() - 1));
                return childBlock.getLastValueBlock();
            }

            @Nullable
            Generation.Entry<K, V> get(K key) {
                if (!this.level.isValueLevel()) {
                    throw new RuntimeException();
                }
                return this.dataBlock.get(key);
            }

            int neighborIndex(K key, NeighborModifier modifier) {
                int insertionPoint = this.dataBlock.search(key);
                return insertionPoint >= 0 ? insertionPoint + modifier.addFound : ~insertionPoint + modifier.addNotFound;
            }

            @Nullable
            <A> Generation.Entry<K, A> neighbor(final K key, final NeighborModifier modifier) {
                SearchResult<K, A> lowerEntry = this.getSearchResult(this.neighborIndex(key, modifier));
                return (Generation.Entry)lowerEntry.match(new SearchResult.Matcher<K, A, Generation.Entry<K, A>>(){

                    @Override
                    Generation.Entry<K, A> found(Generation.Entry<K, A> entry) {
                        return entry;
                    }

                    @Override
                    @Nullable
                    Generation.Entry<K, A> low() {
                        Block previousBlock = Block.this.previousBlock();
                        return previousBlock == null ? null : previousBlock.neighbor(key, modifier);
                    }

                    @Override
                    @Nullable
                    Generation.Entry<K, A> high() {
                        Block nextBlock = Block.this.nextBlock();
                        return nextBlock == null ? null : nextBlock.neighbor(key, modifier);
                    }
                });
            }

            <A> SearchResult<K, A> getSearchResult(int neighborIndex) {
                if (neighborIndex < 0) {
                    return Low.low();
                }
                if (neighborIndex >= this.dataBlock.length()) {
                    return High.high();
                }
                return new Found(this.dataBlock.getEntry(neighborIndex));
            }

            public K getKey(int index) {
                if (!this.level.isValueLevel()) {
                    throw new RuntimeException();
                }
                return this.dataBlock.getKey(index);
            }

            public Generation.Entry<K, V> getEntry(int index) {
                if (!this.level.isValueLevel()) {
                    throw new RuntimeException();
                }
                return this.dataBlock.getEntry(index);
            }

            int search(K key) {
                return this.dataBlock.search(key);
            }
        }
    }

    private static final class TempFileIterator<K>
    implements Iterator<Generation.Entry<K, Long>> {
        private final LittleEndianDataInputStream in;
        private final int tmpCount;
        private final Serializer<K> keySerializer;
        private final LongSerializer longSerializer = new LongSerializer();
        private int i = 0;

        public TempFileIterator(Path tempPath, int tmpCount, Serializer<K> keySerializer) throws IOException {
            this.tmpCount = tmpCount;
            this.keySerializer = keySerializer;
            this.in = new LittleEndianDataInputStream((InputStream)new BufferedInputStream(Files.newInputStream(tempPath, new OpenOption[0]), 131072));
        }

        @Override
        public boolean hasNext() {
            if (this.i < this.tmpCount) {
                return true;
            }
            Closeables2.closeQuietly((Closeable)this.in, (Logger)log);
            return false;
        }

        @Override
        public Generation.Entry<K, Long> next() {
            ++this.i;
            try {
                Object key = this.keySerializer.read((DataInput)this.in);
                Long value = this.longSerializer.read((DataInput)this.in);
                return Generation.Entry.create(key, value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Writer {
        private Writer() {
        }

        @Deprecated
        public static <K, V> void write(File file, Iterator<Generation.Entry<K, V>> iterator, Serializer<K> keySerializer, Serializer<V> valueSerializer, int blocksize, boolean keepDeletions) throws IOException {
            Writer.write(file.toPath(), iterator, keySerializer, valueSerializer, blocksize, keepDeletions);
        }

        public static <K, V> void write(Path path, Iterator<Generation.Entry<K, V>> iterator, Serializer<K> keySerializer, Serializer<V> valueSerializer, int blocksize, boolean keepDeletions) throws IOException {
            if (blocksize > 65536) {
                throw new IllegalArgumentException("block size must be less than 65536");
            }
            Files.createDirectories(path, new FileAttribute[0]);
            BufferedFileDataOutputStream fileOut = new BufferedFileDataOutputStream(path.resolve("index.bin"));
            CountingOutputStream out = new CountingOutputStream((OutputStream)fileOut);
            Path tempPath = Files.createTempFile("tmp", ".bin", new FileAttribute[0]);
            WriteLevelResult result = Writer.writeLevel(out, tempPath, iterator, keySerializer, valueSerializer, blocksize, keepDeletions);
            int tmpCount = result.tmpCount;
            long size = result.size;
            long valueLevelLength = out.getCount();
            Header header = Writer.writeIndex(out, tempPath, tmpCount, keySerializer, blocksize);
            header.valueLevelLength = valueLevelLength;
            header.size = size;
            header.hasDeletions = keepDeletions;
            new HeaderSerializer().write(header, (DataOutput)new LittleEndianDataOutputStream((OutputStream)out));
            fileOut.sync();
            out.close();
        }

        private static Header writeIndex(CountingOutputStream counter, Path tempPath, int tmpCount, Serializer keySerializer, int blocksize) throws IOException {
            if (tmpCount == 0) {
                Files.delete(tempPath);
                Header header = new Header();
                header.indexLevels = 0;
                header.rootLevelStartAddress = 0L;
                header.fileLength = Header.length();
                return header;
            }
            TempFileIterator tmpIterator = new TempFileIterator(tempPath, tmpCount, keySerializer);
            int indexLevels = 0;
            LongSerializer longSerializer = new LongSerializer();
            while (true) {
                long levelStart = counter.getCount();
                ++indexLevels;
                Path nextTempPath = Files.createTempFile("tmp", ".bin", new FileAttribute[0]);
                WriteLevelResult result = Writer.writeLevel(counter, nextTempPath, tmpIterator, keySerializer, longSerializer, blocksize, false);
                tmpCount = result.tmpCount;
                Files.delete(tempPath);
                if (tmpCount <= 1) {
                    Files.delete(nextTempPath);
                    Header header = new Header();
                    header.indexLevels = indexLevels;
                    header.rootLevelStartAddress = levelStart;
                    header.fileLength = counter.getCount() + (long)Header.length();
                    return header;
                }
                tempPath = nextTempPath;
                tmpIterator = new TempFileIterator(tempPath, tmpCount, keySerializer);
            }
        }

        private static <K, V> WriteLevelResult writeLevel(CountingOutputStream counter, Path tempPath, Iterator<Generation.Entry<K, V>> iterator, Serializer<K> keySerializer, Serializer<V> valueSerializer, int blocksize, boolean keepDeletions) throws IOException {
            if (!iterator.hasNext()) {
                return new WriteLevelResult(0, 0L);
            }
            Generation.Entry<K, V> next = iterator.next();
            LittleEndianDataOutputStream tmpOut = new LittleEndianDataOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(tempPath, new OpenOption[0]), 131072));
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            LittleEndianDataOutputStream bufferDataOutput = new LittleEndianDataOutputStream((OutputStream)buffer);
            ByteArrayOutputStream currentBlock = new ByteArrayOutputStream(blocksize);
            CharArrayList keyOffsets = new CharArrayList();
            int tmpCount = 0;
            boolean done = false;
            LittleEndianDataOutputStream out = new LittleEndianDataOutputStream((OutputStream)counter);
            long count = 0L;
            block0: while (!done) {
                currentBlock.reset();
                keyOffsets.clear();
                if (!keepDeletions) {
                    while (next.isDeleted()) {
                        if (!iterator.hasNext()) break block0;
                        next = iterator.next();
                    }
                }
                keySerializer.write(next.getKey(), (DataOutput)tmpOut);
                tmpOut.writeLong(counter.getCount());
                ++tmpCount;
                while (true) {
                    buffer.reset();
                    boolean skipDeleted = Writer.updateBuffer(next, keySerializer, valueSerializer, keepDeletions, (DataOutput)bufferDataOutput);
                    if (4 + 2 * keyOffsets.size() + 2 + currentBlock.size() + buffer.size() > blocksize) {
                        if (currentBlock.size() != 0) break;
                        throw new IllegalArgumentException("key value pair is greater than block size");
                    }
                    if (!skipDeleted) {
                        keyOffsets.add((char)currentBlock.size());
                        buffer.writeTo(currentBlock);
                        ++count;
                    }
                    if (!iterator.hasNext()) {
                        done = true;
                        break;
                    }
                    next = iterator.next();
                }
                if (keyOffsets.size() <= 0) continue;
                long start = counter.getCount();
                out.writeInt(keyOffsets.size());
                for (int i = 0; i < keyOffsets.size(); ++i) {
                    out.writeChar((int)keyOffsets.getChar(i));
                }
                currentBlock.writeTo((OutputStream)out);
                if (counter.getCount() - start <= (long)blocksize) continue;
                log.error((Object)"too big");
            }
            tmpOut.close();
            return new WriteLevelResult(tmpCount, count);
        }

        private static <K, V> boolean updateBuffer(Generation.Entry<K, V> entry, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean keepDeletions, DataOutput bufferDataOutput) throws IOException {
            boolean skipDeleted;
            if (keepDeletions) {
                skipDeleted = false;
                keySerializer.write(entry.getKey(), bufferDataOutput);
                if (entry.isDeleted()) {
                    bufferDataOutput.writeByte(1);
                } else {
                    bufferDataOutput.writeByte(0);
                    valueSerializer.write(entry.getValue(), bufferDataOutput);
                }
            } else if (entry.isDeleted()) {
                skipDeleted = true;
            } else {
                skipDeleted = false;
                keySerializer.write(entry.getKey(), bufferDataOutput);
                valueSerializer.write(entry.getValue(), bufferDataOutput);
            }
            return skipDeleted;
        }

        private static final class WriteLevelResult {
            final int tmpCount;
            final long size;

            private WriteLevelResult(int tmpCount, long size) {
                this.tmpCount = tmpCount;
                this.size = size;
            }
        }
    }
}

