/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;

public interface Generation<K, V>
extends Closeable {
    @Nullable
    public Entry<K, V> get(K var1);

    @Nullable
    public Boolean isDeleted(K var1);

    public Generation<K, V> head(K var1, boolean var2);

    public Generation<K, V> tail(K var1, boolean var2);

    public Generation<K, V> slice(K var1, boolean var2, K var3, boolean var4);

    public Generation<K, V> reverse();

    public Iterator<Entry<K, V>> iterator();

    public Iterator<Entry<K, V>> iterator(K var1, boolean var2);

    public Iterator<Entry<K, V>> reverseIterator();

    public Iterator<Entry<K, V>> reverseIterator(K var1, boolean var2);

    public Comparator<K> getComparator();

    public long size() throws IOException;

    public long sizeInBytes() throws IOException;

    public boolean hasDeletions();

    public File getPath();

    public void checkpoint(File var1) throws IOException;

    public void delete() throws IOException;

    public static final class Entry<K, V> {
        private final K key;
        private final V value;

        public static <K, V> Entry<K, V> createDeleted(K key) {
            return new Entry<K, Object>(key, null);
        }

        public static <K, V> Entry<K, V> create(K key, V value) {
            return new Entry<K, V>(key, value);
        }

        private Entry(K key, @Nullable V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return (V)Preconditions.checkNotNull(this.value);
        }

        public boolean isDeleted() {
            return this.value == null;
        }

        public String toString() {
            return "Entry{key=" + this.key + ", value=" + this.value + ", isDeleted=" + this.isDeleted() + '}';
        }
    }
}

