/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.log4j;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.logstash.log4j.data.HostData;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class JSONEventLayoutV1
extends Layout {
    private static final ObjectMapper JSON = new ObjectMapper().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
    private boolean locationInfo = false;
    private String customUserFields;
    private boolean ignoreThrowable;
    private boolean activeIgnoreThrowable = this.ignoreThrowable = false;
    private String hostname = new HostData().getHostName();
    private String threadName;
    private long timestamp;
    private String ndc;
    private Map mdc;
    private LocationInfo info;
    private HashMap<String, Object> exceptionInformation;
    private static Integer version = 1;
    private Map logstashEvent;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)UTC);
    public static final String ADDITIONAL_DATA_PROPERTY = "net.logstash.log4j.JSONEventLayoutV1.UserFields";

    public static String dateFormat(long timestamp) {
        return ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(timestamp);
    }

    public JSONEventLayoutV1() {
        this(true);
    }

    public JSONEventLayoutV1(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public String format(LoggingEvent loggingEvent) {
        this.threadName = loggingEvent.getThreadName();
        this.timestamp = loggingEvent.getTimeStamp();
        this.exceptionInformation = new HashMap();
        this.mdc = loggingEvent.getProperties();
        this.ndc = loggingEvent.getNDC();
        this.logstashEvent = new HashMap();
        String whoami = ((Object)((Object)this)).getClass().getSimpleName();
        this.logstashEvent.put("@version", version);
        this.logstashEvent.put("@timestamp", JSONEventLayoutV1.dateFormat(this.timestamp));
        if (this.getUserFields() != null) {
            String userFlds = this.getUserFields();
            LogLog.debug((String)("[" + whoami + "] Got user data from log4j property: " + userFlds));
            this.addUserFields(userFlds);
        }
        if (System.getProperty(ADDITIONAL_DATA_PROPERTY) != null) {
            if (this.getUserFields() != null) {
                LogLog.warn((String)("[" + whoami + "] Loading UserFields from command-line. This will override any UserFields set in the log4j configuration file"));
            }
            String userFieldsProperty = System.getProperty(ADDITIONAL_DATA_PROPERTY);
            LogLog.debug((String)("[" + whoami + "] Got user data from system property: " + userFieldsProperty));
            this.addUserFields(userFieldsProperty);
        }
        this.logstashEvent.put("source_host", this.hostname);
        this.logstashEvent.put("message", loggingEvent.getRenderedMessage());
        if (loggingEvent.getThrowableInformation() != null) {
            ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
            if (throwableInformation.getThrowable().getClass().getCanonicalName() != null) {
                this.exceptionInformation.put("exception_class", throwableInformation.getThrowable().getClass().getCanonicalName());
            }
            if (throwableInformation.getThrowable().getMessage() != null) {
                this.exceptionInformation.put("exception_message", throwableInformation.getThrowable().getMessage());
            }
            if (throwableInformation.getThrowableStrRep() != null) {
                String stackTrace = StringUtils.join((Object[])throwableInformation.getThrowableStrRep(), (String)"\n");
                this.exceptionInformation.put("stacktrace", stackTrace);
            }
            this.addEventData("exception", this.exceptionInformation);
        }
        if (this.locationInfo) {
            this.info = loggingEvent.getLocationInformation();
            this.addEventData("file", this.info.getFileName());
            this.addEventData("line_number", this.info.getLineNumber());
            this.addEventData("class", this.info.getClassName());
            this.addEventData("method", this.info.getMethodName());
        }
        this.addEventData("logger_name", loggingEvent.getLoggerName());
        this.addEventData("mdc", this.mdc);
        this.addEventData("ndc", this.ndc);
        this.addEventData("level", loggingEvent.getLevel().toString());
        this.addEventData("thread_name", this.threadName);
        return this.safeString(this.logstashEvent) + "\n";
    }

    private String safeString(Map map) {
        try {
            return JSON.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace(System.err);
            return "{}";
        }
    }

    public boolean ignoresThrowable() {
        return this.ignoreThrowable;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public String getUserFields() {
        return this.customUserFields;
    }

    public void setUserFields(String userFields) {
        this.customUserFields = userFields;
    }

    public void activateOptions() {
        this.activeIgnoreThrowable = this.ignoreThrowable;
    }

    private void addUserFields(String data) {
        if (null != data) {
            String[] pairs;
            for (String pair : pairs = data.split(",")) {
                String[] userField = pair.split(":", 2);
                if (userField[0] == null) continue;
                String key = userField[0];
                String val = userField[1];
                this.addEventData(key, val);
            }
        }
    }

    private void addEventData(String keyname, Object keyval) {
        if (null != keyval) {
            this.logstashEvent.put(keyname, keyval);
        }
    }
}

