
package com.ig.orchestrations.fixp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "SessionId",
    "Timestamp",
    "Code",
    "Reason",
    "MessageType"
})
public class NegotiationReject {

    @JsonProperty("SessionId")
    private UUID sessionId;
    @JsonProperty("Timestamp")
    private Long timestamp;
    @JsonProperty("Code")
    private NegotiationReject.Code code;
    @JsonProperty("Reason")
    private String reason;
    @JsonProperty("MessageType")
    private String messageType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public NegotiationReject() {
    }

    /**
     * 
     * @param reason
     * @param code
     * @param messageType
     * @param sessionId
     * @param timestamp
     */
    public NegotiationReject(UUID sessionId, Long timestamp, NegotiationReject.Code code, String reason, String messageType) {
        super();
        this.sessionId = sessionId;
        this.timestamp = timestamp;
        this.code = code;
        this.reason = reason;
        this.messageType = messageType;
    }

    @JsonProperty("SessionId")
    public UUID getSessionId() {
        return sessionId;
    }

    @JsonProperty("SessionId")
    public void setSessionId(UUID sessionId) {
        this.sessionId = sessionId;
    }

    @JsonProperty("Timestamp")
    public Long getTimestamp() {
        return timestamp;
    }

    @JsonProperty("Timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty("Code")
    public NegotiationReject.Code getCode() {
        return code;
    }

    @JsonProperty("Code")
    public void setCode(NegotiationReject.Code code) {
        this.code = code;
    }

    @JsonProperty("Reason")
    public String getReason() {
        return reason;
    }

    @JsonProperty("Reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @JsonProperty("MessageType")
    public String getMessageType() {
        return messageType;
    }

    @JsonProperty("MessageType")
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NegotiationReject.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sessionId");
        sb.append('=');
        sb.append(((this.sessionId == null)?"<null>":this.sessionId));
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(((this.timestamp == null)?"<null>":this.timestamp));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("reason");
        sb.append('=');
        sb.append(((this.reason == null)?"<null>":this.reason));
        sb.append(',');
        sb.append("messageType");
        sb.append('=');
        sb.append(((this.messageType == null)?"<null>":this.messageType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.reason == null)? 0 :this.reason.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.messageType == null)? 0 :this.messageType.hashCode()));
        result = ((result* 31)+((this.sessionId == null)? 0 :this.sessionId.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.timestamp == null)? 0 :this.timestamp.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof NegotiationReject) == false) {
            return false;
        }
        NegotiationReject rhs = ((NegotiationReject) other);
        return (((((((this.reason == rhs.reason)||((this.reason!= null)&&this.reason.equals(rhs.reason)))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.messageType == rhs.messageType)||((this.messageType!= null)&&this.messageType.equals(rhs.messageType))))&&((this.sessionId == rhs.sessionId)||((this.sessionId!= null)&&this.sessionId.equals(rhs.sessionId))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.timestamp == rhs.timestamp)||((this.timestamp!= null)&&this.timestamp.equals(rhs.timestamp))));
    }

    public enum Code {

        CREDENTIALS("Credentials"),
        UNSPECIFIED("Unspecified"),
        FLOW_TYPE_NOT_SUPPORTED("FlowTypeNotSupported"),
        DUPLICATE_ID("DuplicateId");
        private final String value;
        private final static Map<String, NegotiationReject.Code> CONSTANTS = new HashMap<String, NegotiationReject.Code>();

        static {
            for (NegotiationReject.Code c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Code(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static NegotiationReject.Code fromValue(String value) {
            NegotiationReject.Code constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
