
package com.ig.orchestrations.fixp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "SessionId",
    "Timestamp",
    "ClientFlow",
    "Credentials",
    "MessageType"
})
public class Negotiate {

    @JsonProperty("SessionId")
    private UUID sessionId;
    @JsonProperty("Timestamp")
    private Long timestamp;
    @JsonProperty("ClientFlow")
    private FlowType clientFlow;
    @JsonProperty("Credentials")
    private IgExtensionCredentials credentials;
    @JsonProperty("MessageType")
    private String messageType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Negotiate() {
    }

    /**
     * 
     * @param messageType
     * @param credentials
     * @param clientFlow
     * @param sessionId
     * @param timestamp
     */
    public Negotiate(UUID sessionId, Long timestamp, FlowType clientFlow, IgExtensionCredentials credentials, String messageType) {
        super();
        this.sessionId = sessionId;
        this.timestamp = timestamp;
        this.clientFlow = clientFlow;
        this.credentials = credentials;
        this.messageType = messageType;
    }

    @JsonProperty("SessionId")
    public UUID getSessionId() {
        return sessionId;
    }

    @JsonProperty("SessionId")
    public void setSessionId(UUID sessionId) {
        this.sessionId = sessionId;
    }

    @JsonProperty("Timestamp")
    public Long getTimestamp() {
        return timestamp;
    }

    @JsonProperty("Timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty("ClientFlow")
    public FlowType getClientFlow() {
        return clientFlow;
    }

    @JsonProperty("ClientFlow")
    public void setClientFlow(FlowType clientFlow) {
        this.clientFlow = clientFlow;
    }

    @JsonProperty("Credentials")
    public IgExtensionCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty("Credentials")
    public void setCredentials(IgExtensionCredentials credentials) {
        this.credentials = credentials;
    }

    @JsonProperty("MessageType")
    public String getMessageType() {
        return messageType;
    }

    @JsonProperty("MessageType")
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Negotiate.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sessionId");
        sb.append('=');
        sb.append(((this.sessionId == null)?"<null>":this.sessionId));
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(((this.timestamp == null)?"<null>":this.timestamp));
        sb.append(',');
        sb.append("clientFlow");
        sb.append('=');
        sb.append(((this.clientFlow == null)?"<null>":this.clientFlow));
        sb.append(',');
        sb.append("credentials");
        sb.append('=');
        sb.append(((this.credentials == null)?"<null>":this.credentials));
        sb.append(',');
        sb.append("messageType");
        sb.append('=');
        sb.append(((this.messageType == null)?"<null>":this.messageType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.messageType == null)? 0 :this.messageType.hashCode()));
        result = ((result* 31)+((this.credentials == null)? 0 :this.credentials.hashCode()));
        result = ((result* 31)+((this.clientFlow == null)? 0 :this.clientFlow.hashCode()));
        result = ((result* 31)+((this.sessionId == null)? 0 :this.sessionId.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.timestamp == null)? 0 :this.timestamp.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Negotiate) == false) {
            return false;
        }
        Negotiate rhs = ((Negotiate) other);
        return (((((((this.messageType == rhs.messageType)||((this.messageType!= null)&&this.messageType.equals(rhs.messageType)))&&((this.credentials == rhs.credentials)||((this.credentials!= null)&&this.credentials.equals(rhs.credentials))))&&((this.clientFlow == rhs.clientFlow)||((this.clientFlow!= null)&&this.clientFlow.equals(rhs.clientFlow))))&&((this.sessionId == rhs.sessionId)||((this.sessionId!= null)&&this.sessionId.equals(rhs.sessionId))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.timestamp == rhs.timestamp)||((this.timestamp!= null)&&this.timestamp.equals(rhs.timestamp))));
    }

}
