
package com.ig.orchestrations.fixp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "SessionId",
    "RequestTimestamp",
    "KeepaliveInterval",
    "MessageType"
})
public class EstablishmentAck {

    @JsonProperty("SessionId")
    private UUID sessionId;
    @JsonProperty("RequestTimestamp")
    private Long requestTimestamp;
    @JsonProperty("KeepaliveInterval")
    private Long keepaliveInterval;
    @JsonProperty("MessageType")
    private String messageType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public EstablishmentAck() {
    }

    /**
     * 
     * @param keepaliveInterval
     * @param messageType
     * @param requestTimestamp
     * @param sessionId
     */
    public EstablishmentAck(UUID sessionId, Long requestTimestamp, Long keepaliveInterval, String messageType) {
        super();
        this.sessionId = sessionId;
        this.requestTimestamp = requestTimestamp;
        this.keepaliveInterval = keepaliveInterval;
        this.messageType = messageType;
    }

    @JsonProperty("SessionId")
    public UUID getSessionId() {
        return sessionId;
    }

    @JsonProperty("SessionId")
    public void setSessionId(UUID sessionId) {
        this.sessionId = sessionId;
    }

    @JsonProperty("RequestTimestamp")
    public Long getRequestTimestamp() {
        return requestTimestamp;
    }

    @JsonProperty("RequestTimestamp")
    public void setRequestTimestamp(Long requestTimestamp) {
        this.requestTimestamp = requestTimestamp;
    }

    @JsonProperty("KeepaliveInterval")
    public Long getKeepaliveInterval() {
        return keepaliveInterval;
    }

    @JsonProperty("KeepaliveInterval")
    public void setKeepaliveInterval(Long keepaliveInterval) {
        this.keepaliveInterval = keepaliveInterval;
    }

    @JsonProperty("MessageType")
    public String getMessageType() {
        return messageType;
    }

    @JsonProperty("MessageType")
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EstablishmentAck.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sessionId");
        sb.append('=');
        sb.append(((this.sessionId == null)?"<null>":this.sessionId));
        sb.append(',');
        sb.append("requestTimestamp");
        sb.append('=');
        sb.append(((this.requestTimestamp == null)?"<null>":this.requestTimestamp));
        sb.append(',');
        sb.append("keepaliveInterval");
        sb.append('=');
        sb.append(((this.keepaliveInterval == null)?"<null>":this.keepaliveInterval));
        sb.append(',');
        sb.append("messageType");
        sb.append('=');
        sb.append(((this.messageType == null)?"<null>":this.messageType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.sessionId == null)? 0 :this.sessionId.hashCode()));
        result = ((result* 31)+((this.keepaliveInterval == null)? 0 :this.keepaliveInterval.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.messageType == null)? 0 :this.messageType.hashCode()));
        result = ((result* 31)+((this.requestTimestamp == null)? 0 :this.requestTimestamp.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EstablishmentAck) == false) {
            return false;
        }
        EstablishmentAck rhs = ((EstablishmentAck) other);
        return ((((((this.sessionId == rhs.sessionId)||((this.sessionId!= null)&&this.sessionId.equals(rhs.sessionId)))&&((this.keepaliveInterval == rhs.keepaliveInterval)||((this.keepaliveInterval!= null)&&this.keepaliveInterval.equals(rhs.keepaliveInterval))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.messageType == rhs.messageType)||((this.messageType!= null)&&this.messageType.equals(rhs.messageType))))&&((this.requestTimestamp == rhs.requestTimestamp)||((this.requestTimestamp!= null)&&this.requestTimestamp.equals(rhs.requestTimestamp))));
    }

}
