/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.topic.domain.DynamicConsumer;
import com.icthh.xm.commons.topic.domain.TopicConsumersSpec;
import com.icthh.xm.commons.topic.service.TopicDynamicConsumerConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

@Component
public class TopicConfigurationService
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TopicConfigurationService.class);
    private static final String TENANT_NAME = "tenant";
    private AntPathMatcher matcher = new AntPathMatcher();
    private ObjectMapper ymlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final String configPath;
    private final TopicDynamicConsumerConfiguration topicDynamicConsumerConfiguration;

    public TopicConfigurationService(@Value(value="${spring.application.name}") String appName, TopicDynamicConsumerConfiguration topicDynamicConsumerConfiguration) {
        this.configPath = "/config/tenants/{tenant}/" + appName + "/topic-consumers.yml";
        this.topicDynamicConsumerConfiguration = topicDynamicConsumerConfiguration;
    }

    public void onRefresh(String updatedKey, String config) {
        this.refreshConfig(updatedKey, config);
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.matcher.match(this.configPath, updatedKey);
    }

    public Map<String, List<DynamicConsumer>> getTenantTopicConsumers() {
        return this.topicDynamicConsumerConfiguration.getTenantTopicConsumers();
    }

    private void refreshConfig(String updatedKey, String config) {
        String tenantKey = this.extractTenant(updatedKey);
        if (StringUtils.isEmpty((Object)config)) {
            this.topicDynamicConsumerConfiguration.remove(tenantKey);
        } else {
            this.readSpec(updatedKey, config).ifPresentOrElse(spec -> this.topicDynamicConsumerConfiguration.refreshConfig(spec.getTopics(), tenantKey), () -> log.warn("Skip processing of configuration: [{}]. Specification is null", (Object)updatedKey));
        }
        this.topicDynamicConsumerConfiguration.sendRefreshDynamicConsumersEvent(tenantKey);
    }

    private String extractTenant(String updatedKey) {
        return (String)this.matcher.extractUriTemplateVariables(this.configPath, updatedKey).get(TENANT_NAME);
    }

    private Optional<TopicConsumersSpec> readSpec(String updatedKey, String config) {
        try {
            return Optional.of((TopicConsumersSpec)this.ymlMapper.readValue(config, TopicConsumersSpec.class));
        }
        catch (Exception e) {
            log.error("Error read topic specification from path: {}", (Object)updatedKey, (Object)e);
            return Optional.empty();
        }
    }
}

