/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.service;

import com.icthh.xm.commons.config.client.repository.TenantListRepository;
import com.icthh.xm.commons.topic.domain.DynamicConsumer;
import com.icthh.xm.commons.topic.domain.TopicConfig;
import com.icthh.xm.commons.topic.service.DynamicConsumerConfiguration;
import com.icthh.xm.commons.topic.service.TopicManagerService;
import com.icthh.xm.commons.topic.service.dto.RefreshDynamicConsumersEvent;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnBean(name={"tenantListRepository"})
public class DynamicConsumerConfigurationService
implements ApplicationListener<RefreshDynamicConsumersEvent> {
    private static final Logger log = LoggerFactory.getLogger(DynamicConsumerConfigurationService.class);
    private final List<DynamicConsumerConfiguration> dynamicConsumerConfigurations;
    private final TopicManagerService topicManagerService;
    private final TenantListRepository tenantListRepository;

    public void startDynamicConsumers(String tenantKey) {
        List<DynamicConsumer> dynamicConsumers = this.getDynamicConsumersByTenant(tenantKey);
        dynamicConsumers.forEach(it -> this.topicManagerService.startNewConsumer(tenantKey, it.getConfig(), it.getMessageHandler()));
    }

    public void refreshDynamicConsumersAll() {
        Set tenants = this.tenantListRepository.getTenants();
        tenants.forEach(this::refreshDynamicConsumers);
    }

    public void refreshDynamicConsumers(String tenantKey) {
        List<DynamicConsumer> dynamicConsumers = this.getDynamicConsumersByTenant(tenantKey);
        dynamicConsumers.forEach(it -> this.refreshConsumer(tenantKey, (DynamicConsumer)it));
        List<TopicConfig> newTopicConfigs = dynamicConsumers.stream().map(DynamicConsumer::getConfig).collect(Collectors.toList());
        this.topicManagerService.removeOldConsumers(tenantKey, newTopicConfigs);
    }

    public void stopDynamicConsumers(String tenantKey) {
        this.topicManagerService.stopAllTenantConsumers(tenantKey);
    }

    private List<DynamicConsumer> getDynamicConsumersByTenant(String tenantKey) {
        return this.dynamicConsumerConfigurations.stream().flatMap(it -> it.getDynamicConsumers(tenantKey).stream()).collect(Collectors.toList());
    }

    private void refreshConsumer(String tenantKey, DynamicConsumer updatedDynamicConsumer) {
        this.topicManagerService.processTopicConfig(tenantKey, updatedDynamicConsumer.getConfig(), updatedDynamicConsumer.getMessageHandler());
    }

    public void onApplicationEvent(RefreshDynamicConsumersEvent event) {
        log.debug("OnApplicationEvent with event = {}", (Object)event);
        this.refreshDynamicConsumers(event.getTenantKey());
    }

    public DynamicConsumerConfigurationService(List<DynamicConsumerConfiguration> dynamicConsumerConfigurations, TopicManagerService topicManagerService, TenantListRepository tenantListRepository) {
        this.dynamicConsumerConfigurations = dynamicConsumerConfigurations;
        this.topicManagerService = topicManagerService;
        this.tenantListRepository = tenantListRepository;
    }
}

