/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.message;

import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.topic.domain.TopicConfig;
import com.icthh.xm.commons.topic.message.MessageHandler;
import com.icthh.xm.commons.topic.message.MessageService;
import com.icthh.xm.lep.api.LepManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(name={"lepManager"})
public class LepMessageHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(LepMessageHandler.class);
    private final MessageService messageListenerService;
    private final TenantContextHolder tenantContextHolder;
    private final XmAuthenticationContextHolder authContextHolder;
    private final LepManager lepManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(String message, String tenant, TopicConfig topicConfig) {
        try {
            this.init(tenant);
            this.messageListenerService.onMessage(message, topicConfig);
        }
        finally {
            this.destroy();
        }
    }

    private void init(String tenantKey) {
        TenantContextUtils.setTenant((TenantContextHolder)this.tenantContextHolder, (String)tenantKey);
        this.lepManager.beginThreadContext(threadContext -> {
            threadContext.setValue("tenantContext", (Object)this.tenantContextHolder.getContext());
            threadContext.setValue("authContext", (Object)this.authContextHolder.getContext());
        });
    }

    private void destroy() {
        this.lepManager.endThreadContext();
        this.tenantContextHolder.getPrivilegedContext().destroyCurrentContext();
    }

    public LepMessageHandler(MessageService messageListenerService, TenantContextHolder tenantContextHolder, XmAuthenticationContextHolder authContextHolder, LepManager lepManager) {
        this.messageListenerService = messageListenerService;
        this.tenantContextHolder = tenantContextHolder;
        this.authContextHolder = authContextHolder;
        this.lepManager = lepManager;
    }
}

