/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.security.spring.config;

import com.icthh.xm.commons.security.jwt.JWTConfigurer;
import com.icthh.xm.commons.security.jwt.TokenProvider;
import com.icthh.xm.commons.security.spring.config.UnauthorizedEntryPoint;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;

@EnableWebSecurity
@EnableMethodSecurity(securedEnabled=true)
public class SecurityConfiguration {
    private final String contentSecurityPolicy;
    private final TokenProvider tokenProvider;

    public SecurityConfiguration(TokenProvider tokenProvider, @Value(value="${jhipster.security.content-security-policy}") String contentSecurityPolicy) {
        this.tokenProvider = tokenProvider;
        this.contentSecurityPolicy = contentSecurityPolicy;
    }

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        return web -> web.ignoring().requestMatchers(new String[]{"/h2-console/**"});
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable).headers(headers -> headers.contentSecurityPolicy(csp -> csp.policyDirectives(this.contentSecurityPolicy)).referrerPolicy(referrer -> referrer.policy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN)).frameOptions(HeadersConfigurer.FrameOptionsConfig::deny)).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        this.applyUrlSecurity(http);
        http.with((SecurityConfigurerAdapter)this.securityConfigurerAdapter(), Customizer.withDefaults());
        http.exceptionHandling(exceptionHandler -> exceptionHandler.authenticationEntryPoint((AuthenticationEntryPoint)new UnauthorizedEntryPoint()));
        return (SecurityFilterChain)http.build();
    }

    protected HttpSecurity applyUrlSecurity(HttpSecurity http) {
        return http.authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/api/profile-info"})).permitAll().requestMatchers(new String[]{"/api/**"})).authenticated().requestMatchers(new String[]{"/api/admin/**"})).hasAuthority("SUPER-ADMIN").requestMatchers(new String[]{"/management/health"})).permitAll().requestMatchers(new String[]{"/management/info"})).permitAll().requestMatchers(new String[]{"/management/prometheus"})).permitAll().requestMatchers(new String[]{"/management/prometheus/**"})).permitAll().requestMatchers(new String[]{"/management/**"})).hasAuthority("SUPER-ADMIN").requestMatchers(new String[]{"/v3/api-docs/**"})).hasAuthority("SUPER-ADMIN").requestMatchers(new String[]{"/swagger-resources/configuration/ui"})).permitAll());
    }

    private JWTConfigurer securityConfigurerAdapter() {
        return new JWTConfigurer(this.tokenProvider);
    }
}

