/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.security.oauth2;

import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public interface JwtVerificationKeyClient {
    public byte[] fetchKeyContent();

    default public PublicKey getVerificationKey() {
        byte[] content = this.fetchKeyContent();
        if (content == null) {
            return null;
        }
        CertificateFactory f = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)f.generateCertificate(new ByteArrayInputStream(content));
        return certificate.getPublicKey();
    }
}

