/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.security.internal;

import com.icthh.xm.commons.security.internal.XmAuthenticationDetails;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class XmAuthentication
extends AbstractAuthenticationToken {
    private final XmAuthenticationDetails details;
    private Object credentials;

    public XmAuthentication(XmAuthenticationDetails details, Object credentials) {
        super(null);
        this.details = details;
        this.credentials = credentials;
        this.setAuthenticated(false);
    }

    public XmAuthentication(XmAuthenticationDetails details, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.details = details;
        this.credentials = credentials;
        super.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public String getPrincipal() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.details.getUserKey()}) ? this.details.getUserKey() : this.details.getClientId();
    }

    public boolean isClientOnly() {
        return this.details.getUserKey() == null && this.details.getUserName() == null;
    }

    @Nullable
    public XmAuthenticationDetails getDetails() {
        return this.details;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        Assert.isTrue((!isAuthenticated ? 1 : 0) != 0, (String)"Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
        super.setAuthenticated(false);
    }

    public void eraseCredentials() {
        super.eraseCredentials();
        this.credentials = null;
    }
}

