/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.request.internal;

import java.util.HashMap;
import java.util.Map;

class XmRequestContextData {
    private static final ThreadLocal<XmRequestContextData> THREAD_LOCAL = ThreadLocal.withInitial(XmRequestContextData::new);
    private Map<String, Object> model = new HashMap<String, Object>();

    XmRequestContextData() {
    }

    static XmRequestContextData get() {
        return THREAD_LOCAL.get();
    }

    void destroyCurrent() {
        THREAD_LOCAL.remove();
    }

    boolean containsKey(String key) {
        return this.model.containsKey(key);
    }

    <T> T getValue(String key, Class<T> type) {
        return type.cast(this.model.get(key));
    }

    <T> T getValueOrDefault(String key, Class<T> type, T defaultValue) {
        return type.cast(this.model.getOrDefault(key, defaultValue));
    }

    void putValue(String key, Object value) {
        this.model.put(key, value);
    }
}

