/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.spring;

import com.icthh.xm.commons.logging.util.MdcUtils;
import com.icthh.xm.commons.security.XmAuthenticationContext;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantKey;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.springframework.web.servlet.HandlerInterceptor;

public class XmLoggingInterceptor
implements HandlerInterceptor {
    private final XmAuthenticationContextHolder authenticationContextHolder;
    private final TenantContextHolder tenantContextHolder;

    public XmLoggingInterceptor(XmAuthenticationContextHolder authenticationContextHolder, TenantContextHolder tenantContextHolder) {
        this.authenticationContextHolder = authenticationContextHolder;
        this.tenantContextHolder = tenantContextHolder;
    }

    private String getLogin() {
        XmAuthenticationContext authContext = this.authenticationContextHolder.getContext();
        return authContext.getLogin().orElse("[unknown]");
    }

    private String getTenantName() {
        Optional tenantName = this.tenantContextHolder.getContext().getTenantKey();
        return tenantName.isPresent() ? ((TenantKey)tenantName.get()).getValue() : "[no tenant]";
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        MdcUtils.putRid((String)(MdcUtils.generateRid() + ":" + this.getLogin() + ":" + this.getTenantName()));
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        MdcUtils.clear();
    }
}

