/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.spring.config;

import com.icthh.xm.commons.config.client.config.XmConfigAutoConfigration;
import com.icthh.xm.commons.config.client.repository.TenantListRepository;
import com.icthh.xm.commons.logging.spring.config.ServiceLoggingAspectConfiguration;
import com.icthh.xm.commons.logging.web.spring.config.RestLoggingAspectConfiguration;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.security.spring.config.XmAuthenticationContextConfiguration;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.spring.config.TenantContextConfiguration;
import com.icthh.xm.commons.web.spring.TenantInterceptor;
import com.icthh.xm.commons.web.spring.TenantVerifyInterceptor;
import com.icthh.xm.commons.web.spring.XmLoggingInterceptor;
import com.icthh.xm.commons.web.spring.config.LogstashConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

@Configuration
@Import(value={LogstashConfiguration.class, XmAuthenticationContextConfiguration.class, TenantContextConfiguration.class, ServiceLoggingAspectConfiguration.class, RestLoggingAspectConfiguration.class, XmConfigAutoConfigration.class})
public class XmMsWebConfiguration {
    @Bean
    @Order(value=1)
    TenantInterceptor tenantInterceptor(XmAuthenticationContextHolder xmAuthenticationContextHolder, TenantContextHolder tenantContextHolder) {
        return new TenantInterceptor(xmAuthenticationContextHolder, tenantContextHolder);
    }

    @Bean
    @Order(value=2)
    @ConditionalOnExpression(value="${xm-config.enabled} && ${tenant.reject-suspended:true}")
    TenantVerifyInterceptor tenantVerifyInterceptor(TenantListRepository tenantListRepository, TenantContextHolder tenantContextHolder) {
        return new TenantVerifyInterceptor(tenantListRepository, tenantContextHolder);
    }

    @Bean
    XmLoggingInterceptor xmLoggingInterceptor(XmAuthenticationContextHolder xmAuthenticationContextHolder, TenantContextHolder tenantContextHolder) {
        return new XmLoggingInterceptor(xmAuthenticationContextHolder, tenantContextHolder);
    }
}

