/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.jsonb;

import com.icthh.xm.commons.migration.db.jsonb.CustomExpression;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="'${spring.datasource.url}'.startsWith('jdbc:postgresql:')")
public class JsonbExpression
implements CustomExpression {
    @Override
    public Expression<JsonJdbcType> jsonQuery(CriteriaBuilder cb, Root<?> root, String column, String jsonPath) {
        return this.jsonQuery(cb, root, column, jsonPath, JsonJdbcType.class);
    }

    @Override
    public <T> Expression<T> jsonQuery(CriteriaBuilder cb, Root<?> root, String column, String jsonPath, Class<T> type) {
        return cb.function("json_query", type, new Expression[]{root.get(column), cb.literal((Object)jsonPath)});
    }

    @Override
    public Expression<?> toExpression(CriteriaBuilder cb, Object object) {
        return this.toJsonB(cb, object);
    }

    @Override
    public Expression<?> toJsonB(CriteriaBuilder cb, Object object) {
        return this.toJsonB(cb, object, JsonJdbcType.class);
    }

    @Override
    public <T> Expression<T> toJsonB(CriteriaBuilder cb, Object object, Class<T> type) {
        return this.toJsonB(cb, cb.literal(object), type);
    }

    @Override
    public Expression<JsonJdbcType> toJsonB(CriteriaBuilder cb, Expression<?> expression) {
        return this.toJsonB(cb, expression, JsonJdbcType.class);
    }

    @Override
    public <T> Expression<T> toJsonB(CriteriaBuilder cb, Expression<?> expression, Class<T> type) {
        return cb.function("to_json_b", type, new Expression[]{expression});
    }

    @Override
    public Expression<?> toJsonbText(CriteriaBuilder cb, Object object) {
        return this.toJsonbText(cb, object, JsonJdbcType.class);
    }

    @Override
    public <T> Expression<T> toJsonbText(CriteriaBuilder cb, Object object, Class<T> type) {
        return this.toJsonbText(cb, cb.literal(object), type);
    }

    @Override
    public Expression<JsonJdbcType> toJsonbText(CriteriaBuilder cb, Expression<?> expression) {
        return this.toJsonbText(cb, expression, JsonJdbcType.class);
    }

    @Override
    public <T> Expression<T> toJsonbText(CriteriaBuilder cb, Expression<?> expression, Class<T> type) {
        return cb.function("to_json_b_text", type, new Expression[]{expression});
    }
}

